/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.interpreter;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.DataContext;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Context;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Interpreter;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Scalar;
import com.hazelcast.shaded.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Function1;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.BlockStatement;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ClassDeclaration;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.MemberDeclaration;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.MemberExpression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.MethodDeclaration;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Statement;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgram;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlConformanceEnum;
import com.hazelcast.shaded.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.codehaus.commons.compiler.CompileException;
import com.hazelcast.shaded.org.codehaus.commons.compiler.CompilerFactoryFactory;
import com.hazelcast.shaded.org.codehaus.commons.compiler.IClassBodyEvaluator;
import com.hazelcast.shaded.org.codehaus.commons.compiler.ICompilerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JaninoRexCompiler
implements Interpreter.ScalarCompiler {
    private final RexBuilder rexBuilder;

    public JaninoRexCompiler(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    @Override
    public Scalar.Producer compile(List<RexNode> nodes, RelDataType inputRowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        for (RexNode node : nodes) {
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder list = new BlockBuilder();
        BlockBuilder staticList = new BlockBuilder().withRemoveUnused(false);
        ParameterExpression context_ = Expressions.parameter(Context.class, "context");
        ParameterExpression outputValues_ = Expressions.parameter(Object[].class, "outputValues");
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(this.rexBuilder.getTypeFactory().getTypeSystem());
        RexToLixTranslator.InputGetterImpl inputGetter = new RexToLixTranslator.InputGetterImpl(Expressions.field((Expression)context_, BuiltInMethod.CONTEXT_VALUES.field), PhysTypeImpl.of(javaTypeFactory, inputRowType, JavaRowFormat.ARRAY, false));
        Function1<String, RexToLixTranslator.InputGetter> correlates = a0 -> {
            throw new UnsupportedOperationException();
        };
        MemberExpression root = Expressions.field((Expression)context_, BuiltInMethod.CONTEXT_ROOT.field);
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        List<Expression> expressionList = RexToLixTranslator.translateProjects(program, javaTypeFactory, conformance, list, staticList, null, root, inputGetter, correlates);
        Ord.forEach(expressionList, (expression, i) -> list.add(Expressions.statement(Expressions.assign(Expressions.arrayIndex(outputValues_, Expressions.constant(i)), expression))));
        return JaninoRexCompiler.baz(context_, outputValues_, list.toBlock(), staticList.toBlock().statements);
    }

    static Scalar.Producer baz(ParameterExpression context_, ParameterExpression outputValues_, BlockStatement block, List<Statement> declList) {
        ArrayList<MemberDeclaration> declarations = new ArrayList<MemberDeclaration>();
        ArrayList<MethodDeclaration> innerDeclarations = new ArrayList<MethodDeclaration>();
        ArrayList<Statement> statements = new ArrayList<Statement>(declList);
        statements.add(Expressions.return_(null, Expressions.new_(Scalar.class, ImmutableList.of(), innerDeclarations)));
        declarations.add(Expressions.methodDecl(1, Scalar.class, BuiltInMethod.FUNCTION_APPLY.method.getName(), ImmutableList.of(DataContext.ROOT), Expressions.block(statements)));
        ParameterExpression objectRoot = Expressions.parameter(Object.class, "root");
        declarations.add(Expressions.methodDecl(1, Object.class, BuiltInMethod.FUNCTION_APPLY.method.getName(), ImmutableList.of(objectRoot), Expressions.block(Expressions.return_(null, Expressions.call((Expression)Expressions.parameter(Scalar.Producer.class, "this"), BuiltInMethod.FUNCTION_APPLY.method, Expressions.convert_(objectRoot, DataContext.class))))));
        innerDeclarations.add(Expressions.methodDecl(1, Void.TYPE, BuiltInMethod.SCALAR_EXECUTE2.method.getName(), ImmutableList.of(context_, outputValues_), block));
        BlockBuilder builder = new BlockBuilder();
        Expression values_ = builder.append("values", Expressions.newArrayBounds(Object.class, 1, Expressions.constant(1)));
        builder.add(Expressions.statement(Expressions.call((Expression)Expressions.parameter(Scalar.class, "this"), BuiltInMethod.SCALAR_EXECUTE2.method, context_, values_)));
        builder.add(Expressions.return_(null, Expressions.arrayIndex(values_, Expressions.constant(0))));
        innerDeclarations.add(Expressions.methodDecl(1, Object.class, BuiltInMethod.SCALAR_EXECUTE1.method.getName(), ImmutableList.of(context_), builder.toBlock()));
        ClassDeclaration classDeclaration = Expressions.classDecl(1, "Buzz", null, ImmutableList.of(Scalar.Producer.class), declarations);
        String s2 = Expressions.toString(declarations, "\n", false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s2);
        }
        try {
            return JaninoRexCompiler.getScalar(classDeclaration, s2);
        }
        catch (CompileException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Scalar.Producer getScalar(ClassDeclaration expr, String s2) throws CompileException, IOException {
        ICompilerFactory compilerFactory;
        ClassLoader classLoader = Objects.requireNonNull(JaninoRexCompiler.class.getClassLoader(), "classLoader");
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory(classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setImplementedInterfaces(new Class[]{Scalar.Producer.class});
        cbe.setParentClassLoader(classLoader);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            cbe.setDebuggingInformation(true, true, true);
        }
        return (Scalar.Producer)cbe.createInstance(new StringReader(s2));
    }
}

