/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.linq4j.tree;

import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.MemberDeclaration;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;

public class NewExpression
extends Expression {
    public final Type type;
    public final List<Expression> arguments;
    public final @Nullable List<MemberDeclaration> memberDeclarations;
    private int hash;

    public NewExpression(Type type, List<Expression> arguments, @Nullable List<MemberDeclaration> memberDeclarations) {
        super(ExpressionType.New, type);
        this.type = type;
        this.arguments = arguments;
        this.memberDeclarations = memberDeclarations;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        List<Expression> arguments = Expressions.acceptExpressions(this.arguments, shuttle);
        List<MemberDeclaration> memberDeclarations = this.memberDeclarations == null ? null : Expressions.acceptMemberDeclarations(this.memberDeclarations, shuttle);
        return shuttle.visit(this, arguments, memberDeclarations);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append("new ").append(this.type).list("(\n", ",\n", ")", this.arguments);
        if (this.memberDeclarations != null) {
            writer.list("{\n", "", "}", this.memberDeclarations);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NewExpression that = (NewExpression)o;
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.memberDeclarations != null ? !this.memberDeclarations.equals(that.memberDeclarations) : that.memberDeclarations != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, ((Expression)this).type, this.type, this.arguments, this.memberDeclarations});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

