/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.metadata;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.Metadata;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;

public class MetadataDef<M extends Metadata> {
    public final Class<M> metadataClass;
    public final Class<? extends MetadataHandler<M>> handlerClass;
    public final ImmutableList<Method> methods;

    private MetadataDef(Class<M> metadataClass, Class<? extends MetadataHandler<M>> handlerClass, Method ... methods) {
        this.metadataClass = metadataClass;
        this.handlerClass = handlerClass;
        this.methods = Arrays.stream(methods).sorted(Comparator.comparing(Method::getName)).collect(Util.toImmutableList());
        SortedMap<String, Method> handlerMethods = MetadataHandler.handlerMethods(handlerClass);
        Preconditions.checkArgument(this.methods.size() == handlerMethods.size(), "handlerMethods.length = methods.length", new Object[]{this.methods, handlerMethods});
        Pair.forEach(this.methods, handlerMethods.values(), (method, handlerMethod) -> {
            List<Class<?>> methodTypes = Arrays.asList(method.getParameterTypes());
            List<Class<?>> handlerTypes = Arrays.asList(handlerMethod.getParameterTypes());
            Preconditions.checkArgument(methodTypes.size() + 2 == handlerTypes.size(), "methodTypes.size + 2 == handlerTypes.size", new Object[]{handlerMethod, methodTypes, handlerTypes});
            Preconditions.checkArgument(RelNode.class.isAssignableFrom(handlerTypes.get(0)), "RelNode.assignableFrom(handlerType[0])", new Object[]{handlerMethod, handlerTypes});
            Preconditions.checkArgument(RelMetadataQuery.class == handlerTypes.get(1), "handlerTypes[1] == RelMetadataQuery", new Object[]{handlerMethod, handlerTypes});
            Preconditions.checkArgument(methodTypes.equals(Util.skip(handlerTypes, 2)), "methodTypes == handlerTypes.skip(2)", new Object[]{handlerMethod, methodTypes, handlerTypes});
        });
    }

    public static <M extends Metadata> MetadataDef<M> of(Class<M> metadataClass, Class<? extends MetadataHandler<M>> handlerClass, Method ... methods) {
        return new MetadataDef<M>(metadataClass, handlerClass, methods);
    }
}

