/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rex;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgram;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUtil;
import com.hazelcast.shaded.org.apache.calcite.runtime.CalciteException;
import com.hazelcast.shaded.org.apache.calcite.runtime.Resources;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class RexCallBinding
extends SqlOperatorBinding {
    private final List<RexNode> operands;
    private final List<RelCollation> inputCollations;

    public RexCallBinding(RelDataTypeFactory typeFactory, SqlOperator sqlOperator, List<? extends RexNode> operands, List<RelCollation> inputCollations) {
        super(typeFactory, sqlOperator);
        this.operands = ImmutableList.copyOf(operands);
        this.inputCollations = ImmutableList.copyOf(inputCollations);
    }

    public static RexCallBinding create(RelDataTypeFactory typeFactory, RexCall call, List<RelCollation> inputCollations) {
        return RexCallBinding.create(typeFactory, call, null, inputCollations);
    }

    public static RexCallBinding create(RelDataTypeFactory typeFactory, RexCall call, @Nullable RexProgram program, List<RelCollation> inputCollations) {
        List<RexNode> operands = program != null ? program.expandList(call.getOperands()) : call.getOperands();
        switch (call.getKind()) {
            case CAST: 
            case SAFE_CAST: {
                return new RexCastCallBinding(typeFactory, call.getOperator(), operands, call.getType(), inputCollations);
            }
        }
        return new RexCallBinding(typeFactory, call.getOperator(), operands, inputCollations);
    }

    @Override
    public @Nullable String getStringLiteralOperand(int ordinal) {
        return RexLiteral.stringValue(this.operands.get(ordinal));
    }

    @Override
    public int getIntLiteralOperand(int ordinal) {
        return RexLiteral.intValue(this.operands.get(ordinal));
    }

    @Override
    public <T> @Nullable T getOperandLiteralValue(int ordinal, Class<T> clazz) {
        RexNode node = this.operands.get(ordinal);
        if (node instanceof RexLiteral) {
            return ((RexLiteral)node).getValueAs(clazz);
        }
        return clazz.cast(RexLiteral.value(node));
    }

    @Override
    public SqlMonotonicity getOperandMonotonicity(int ordinal) {
        RexNode operand = this.operands.get(ordinal);
        if (operand instanceof RexInputRef) {
            for (RelCollation ic : this.inputCollations) {
                if (ic.getFieldCollations().isEmpty()) continue;
                for (RelFieldCollation rfc : ic.getFieldCollations()) {
                    if (rfc.getFieldIndex() != ((RexInputRef)operand).getIndex()) continue;
                    return rfc.direction.monotonicity();
                }
            }
        } else if (operand instanceof RexCall) {
            RexCallBinding binding = RexCallBinding.create(this.typeFactory, (RexCall)operand, this.inputCollations);
            return ((RexCall)operand).getOperator().getMonotonicity(binding);
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return RexUtil.isNullLiteral(this.operands.get(ordinal), allowCast);
    }

    @Override
    public boolean isOperandLiteral(int ordinal, boolean allowCast) {
        return RexUtil.isLiteral(this.operands.get(ordinal), allowCast);
    }

    public List<RexNode> operands() {
        return this.operands;
    }

    @Override
    public int getOperandCount() {
        return this.operands.size();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        return this.operands.get(ordinal).getType();
    }

    @Override
    public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
        return SqlUtil.newContextException(SqlParserPos.ZERO, e);
    }

    private static class RexCastCallBinding
    extends RexCallBinding {
        private final RelDataType type;

        RexCastCallBinding(RelDataTypeFactory typeFactory, SqlOperator sqlOperator, List<? extends RexNode> operands, RelDataType type, List<RelCollation> inputCollations) {
            super(typeFactory, sqlOperator, operands, inputCollations);
            this.type = type;
        }

        @Override
        public RelDataType getOperandType(int ordinal) {
            if (ordinal == 1) {
                return this.type;
            }
            return super.getOperandType(ordinal);
        }
    }
}

