/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.runtime;

import com.hazelcast.shaded.com.google.common.base.Splitter;
import com.hazelcast.shaded.com.google.common.base.Strings;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.DataContext;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.ByteString;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.DateTimeUtils;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.Spaces;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnitRange;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Row;
import com.hazelcast.shaded.org.apache.calcite.linq4j.AbstractEnumerable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.CartesianProductEnumerator;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Deterministic;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Function1;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.NonDeterministic;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Primitive;
import com.hazelcast.shaded.org.apache.calcite.rel.type.TimeFrame;
import com.hazelcast.shaded.org.apache.calcite.rel.type.TimeFrameSet;
import com.hazelcast.shaded.org.apache.calcite.runtime.FlatLists;
import com.hazelcast.shaded.org.apache.calcite.runtime.Like;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.util.NumberUtil;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.apache.calcite.util.TimeWithTimeZoneString;
import com.hazelcast.shaded.org.apache.calcite.util.TimestampWithTimeZoneString;
import com.hazelcast.shaded.org.apache.calcite.util.Unsafe;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.apache.calcite.util.format.FormatElement;
import com.hazelcast.shaded.org.apache.calcite.util.format.FormatModels;
import com.hazelcast.shaded.org.apache.commons.codec.DecoderException;
import com.hazelcast.shaded.org.apache.commons.codec.binary.Base32;
import com.hazelcast.shaded.org.apache.commons.codec.binary.Hex;
import com.hazelcast.shaded.org.apache.commons.codec.digest.DigestUtils;
import com.hazelcast.shaded.org.apache.commons.codec.language.Soundex;
import com.hazelcast.shaded.org.apache.commons.lang3.StringUtils;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.PolyNull;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.regex.Pattern;

@Deterministic
public class SqlFunctions {
    private static final DecimalFormat DOUBLE_FORMAT = NumberUtil.decimalFormat("0.0E0");
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final DateTimeFormatter ROOT_DAY_FORMAT = DateTimeFormatter.ofPattern("EEEE", Locale.ROOT);
    private static final DateTimeFormatter ROOT_MONTH_FORMAT = DateTimeFormatter.ofPattern("MMMM", Locale.ROOT);
    private static final Soundex SOUNDEX = new Soundex();
    private static final int SOUNDEX_LENGTH = 4;
    private static final Pattern FROM_BASE64_REGEXP = Pattern.compile("[\\t\\n\\r\\s]");
    private static final Base32 BASE_32 = new Base32();
    private static final Function1<List<Object>, Enumerable<Object>> LIST_AS_ENUMERABLE = a0 -> a0 == null ? Linq4j.emptyEnumerable() : Linq4j.asEnumerable(a0);
    private static final Function1<Object[], Enumerable<@Nullable Object[]>> ARRAY_CARTESIAN_PRODUCT = lists -> {
        ArrayList<Enumerator<@Nullable T>> enumerators = new ArrayList();
        for (Object list : lists) {
            enumerators.add(Linq4j.enumerator((List)list));
        }
        final Enumerator<List<@Nullable T>> product = Linq4j.product(enumerators);
        return new AbstractEnumerable<Object[]>(){

            @Override
            public Enumerator<@Nullable Object[]> enumerator() {
                return Linq4j.transform(product, List::toArray);
            }
        };
    };
    private static final ThreadLocal<@Nullable Map<String, AtomicLong>> THREAD_SEQUENCES = ThreadLocal.withInitial(HashMap::new);
    private static final Pattern PATTERN_0_STAR_E = Pattern.compile("0*E");
    private static final ByteString SINGLE_SPACE_BYTE_STRING = ByteString.of("20", 16);
    private static final DateTimeFormatter BIG_QUERY_TIMESTAMP_LITERAL_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().padNext(1, ' ').optionalStart().appendLiteral('T').optionalEnd().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NOT_NEGATIVE).optionalStart().appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).optionalEnd().optionalStart().parseLenient().appendOffsetId().toFormatter(Locale.ROOT);
    private static final boolean IS_JDK_8 = System.getProperty("java.version").startsWith("1.8");

    private SqlFunctions() {
    }

    @NonDeterministic
    public static boolean throwUnless(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
        return condition;
    }

    public static String toBase64(String string) {
        return SqlFunctions.toBase64_(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String toBase64(ByteString string) {
        return SqlFunctions.toBase64_(string.getBytes());
    }

    private static String toBase64_(byte[] bytes) {
        String base64 = Base64.getEncoder().encodeToString(bytes);
        StringBuilder str = new StringBuilder(base64.length() + base64.length() / 76);
        Splitter.fixedLength(76).split(base64).iterator().forEachRemaining(s2 -> {
            str.append((String)s2);
            str.append("\n");
        });
        return str.substring(0, str.length() - 1);
    }

    public static @Nullable ByteString fromBase64(String base64) {
        try {
            base64 = FROM_BASE64_REGEXP.matcher(base64).replaceAll("");
            return new ByteString(Base64.getDecoder().decode(base64));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String toBase32(String string) {
        return SqlFunctions.toBase32_(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String toBase32(ByteString string) {
        return SqlFunctions.toBase32_(string.getBytes());
    }

    private static String toBase32_(byte[] bytes) {
        return BASE_32.encodeToString(bytes);
    }

    public static ByteString fromBase32(String base32) {
        return new ByteString(BASE_32.decode(base32));
    }

    public static ByteString fromHex(String hex) {
        try {
            return new ByteString(Hex.decodeHex(hex));
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Failed to decode hex string: %s", hex), e);
        }
    }

    public static String toHex(ByteString byteString) {
        return Hex.encodeHexString(byteString.getBytes());
    }

    public static String md5(String string) {
        return DigestUtils.md5Hex(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String md5(ByteString string) {
        return DigestUtils.md5Hex(string.getBytes());
    }

    public static String sha1(String string) {
        return DigestUtils.sha1Hex(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha1(ByteString string) {
        return DigestUtils.sha1Hex(string.getBytes());
    }

    public static String sha256(String string) {
        return DigestUtils.sha256Hex(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha256(ByteString string) {
        return DigestUtils.sha256Hex(string.getBytes());
    }

    public static String sha512(String string) {
        return DigestUtils.sha512Hex(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha512(ByteString string) {
        return DigestUtils.sha512Hex(string.getBytes());
    }

    public static String regexpReplace(String s2, String regex, String replacement) {
        return SqlFunctions.regexpReplace(s2, regex, replacement, 1, 0, null);
    }

    public static String regexpReplace(String s2, String regex, String replacement, int pos) {
        return SqlFunctions.regexpReplace(s2, regex, replacement, pos, 0, null);
    }

    public static String regexpReplace(String s2, String regex, String replacement, int pos, int occurrence) {
        return SqlFunctions.regexpReplace(s2, regex, replacement, pos, occurrence, null);
    }

    public static String regexpReplace(String s2, String regex, String replacement, int pos, int occurrence, @Nullable String matchType) {
        if (pos < 1 || pos > s2.length()) {
            throw Static.RESOURCE.invalidInputForRegexpReplace(Integer.toString(pos)).ex();
        }
        int flags = SqlFunctions.makeRegexpFlags(matchType);
        Pattern pattern = Pattern.compile(regex, flags);
        return Unsafe.regexpReplace(s2, pattern, replacement, pos, occurrence);
    }

    private static int makeRegexpFlags(@Nullable String stringFlags) {
        int flags = 0;
        if (stringFlags != null) {
            block6: for (int i = 0; i < stringFlags.length(); ++i) {
                switch (stringFlags.charAt(i)) {
                    case 'i': {
                        flags |= 2;
                        continue block6;
                    }
                    case 'c': {
                        flags &= 0xFFFFFFFD;
                        continue block6;
                    }
                    case 'n': {
                        flags |= 0x20;
                        continue block6;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block6;
                    }
                    default: {
                        throw Static.RESOURCE.invalidInputForRegexpReplace(stringFlags).ex();
                    }
                }
            }
        }
        return flags;
    }

    public static String lpad(String originalValue, int returnLength, String pattern) {
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.isEmpty()) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        StringBuilder paddedS = new StringBuilder();
        for (int i = 0; i < paddingLengthRequired; ++i) {
            char curChar = pattern.charAt(i % patternLength);
            paddedS.append(curChar);
        }
        paddedS.append(originalValue);
        return paddedS.toString();
    }

    public static String lpad(String originalValue, int returnLength) {
        return SqlFunctions.lpad(originalValue, returnLength, " ");
    }

    public static ByteString lpad(ByteString originalValue, int returnLength, ByteString pattern) {
        int i;
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.length() == 0) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        byte[] bytes = new byte[returnLength];
        for (i = 0; i < paddingLengthRequired; ++i) {
            byte curByte;
            bytes[i] = curByte = pattern.byteAt(i % patternLength);
        }
        for (i = paddingLengthRequired; i < returnLength; ++i) {
            bytes[i] = originalValue.byteAt(i - paddingLengthRequired);
        }
        return new ByteString(bytes);
    }

    public static ByteString lpad(ByteString originalValue, int returnLength) {
        return SqlFunctions.lpad(originalValue, returnLength, SINGLE_SPACE_BYTE_STRING);
    }

    public static String rpad(String originalValue, int returnLength, String pattern) {
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.isEmpty()) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        if (returnLength <= originalValue.length()) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalValue.length();
        int patternLength = pattern.length();
        StringBuilder paddedS = new StringBuilder();
        paddedS.append(originalValue);
        for (int i = 0; i < paddingLengthRequired; ++i) {
            char curChar = pattern.charAt(i % patternLength);
            paddedS.append(curChar);
        }
        return paddedS.toString();
    }

    public static String rpad(String originalValue, int returnLength) {
        return SqlFunctions.rpad(originalValue, returnLength, " ");
    }

    public static ByteString rpad(ByteString originalValue, int returnLength, ByteString pattern) {
        int i;
        if (returnLength < 0) {
            throw Static.RESOURCE.illegalNegativePadLength().ex();
        }
        if (pattern.length() == 0) {
            throw Static.RESOURCE.illegalEmptyPadPattern().ex();
        }
        int originalLength = originalValue.length();
        if (returnLength <= originalLength) {
            return originalValue.substring(0, returnLength);
        }
        int paddingLengthRequired = returnLength - originalLength;
        int patternLength = pattern.length();
        byte[] bytes = new byte[returnLength];
        for (i = 0; i < originalLength; ++i) {
            bytes[i] = originalValue.byteAt(i);
        }
        for (i = returnLength - paddingLengthRequired; i < returnLength; ++i) {
            byte curByte;
            bytes[i] = curByte = pattern.byteAt(i % patternLength);
        }
        return new ByteString(bytes);
    }

    public static ByteString rpad(ByteString originalValue, int returnLength) {
        return SqlFunctions.rpad(originalValue, returnLength, SINGLE_SPACE_BYTE_STRING);
    }

    public static boolean endsWith(String s0, String s1) {
        return s0.endsWith(s1);
    }

    public static boolean endsWith(ByteString s0, ByteString s1) {
        return s0.endsWith(s1);
    }

    public static boolean startsWith(String s0, String s1) {
        return s0.startsWith(s1);
    }

    public static boolean startsWith(ByteString s0, ByteString s1) {
        return s0.startsWith(s1);
    }

    public static List<String> split(String s2, String delimiter) {
        if (s2.isEmpty()) {
            return ImmutableList.of();
        }
        if (delimiter.isEmpty()) {
            return ImmutableList.of(s2);
        }
        ImmutableList.Builder list = ImmutableList.builder();
        int i = 0;
        while (true) {
            int j;
            if ((j = s2.indexOf(delimiter, i)) < 0) {
                list.add(s2.substring(i));
                return list.build();
            }
            list.add(s2.substring(i, j));
            i = j + delimiter.length();
        }
    }

    public static List<String> split(String s2) {
        return SqlFunctions.split(s2, ",");
    }

    public static List<ByteString> split(ByteString s2, ByteString delimiter) {
        if (s2.length() == 0) {
            return ImmutableList.of();
        }
        if (delimiter.length() == 0) {
            return ImmutableList.of(s2);
        }
        ImmutableList.Builder list = ImmutableList.builder();
        int i = 0;
        while (true) {
            int j;
            if ((j = s2.indexOf(delimiter, i)) < 0) {
                list.add(s2.substring(i));
                return list.build();
            }
            list.add(s2.substring(i, j));
            i = j + delimiter.length();
        }
    }

    public static String substring(String c, int s2) {
        int s0 = s2 - 1;
        if (s0 <= 0) {
            return c;
        }
        if (s2 > c.length()) {
            return "";
        }
        return c.substring(s0);
    }

    public static String substring(String c, int s2, int l) {
        int lc = c.length();
        long e = (long)s2 + (long)l;
        if (l < 0) {
            throw Static.RESOURCE.illegalNegativeSubstringLength().ex();
        }
        if (s2 > lc || e < 1L) {
            return "";
        }
        int s0 = Math.max(s2 - 1, 0);
        long e0 = Math.min(e - 1L, (long)lc);
        return c.substring(s0, (int)e0);
    }

    public static ByteString substring(ByteString c, int s2) {
        int s0 = s2 - 1;
        if (s0 <= 0) {
            return c;
        }
        if (s2 > c.length()) {
            return ByteString.EMPTY;
        }
        return c.substring(s0);
    }

    public static ByteString substring(ByteString c, int s2, int l) {
        int lc = c.length();
        int e = s2 + l;
        if (l < 0) {
            throw Static.RESOURCE.illegalNegativeSubstringLength().ex();
        }
        if (s2 > lc || e < 1) {
            return ByteString.EMPTY;
        }
        int s0 = Math.max(s2 - 1, 0);
        int e0 = Math.min(e - 1, lc);
        return c.substring(s0, e0);
    }

    public static String upper(String s2) {
        return s2.toUpperCase(Locale.ROOT);
    }

    public static String lower(String s2) {
        return s2.toLowerCase(Locale.ROOT);
    }

    public static String initcap(String s2) {
        int len = s2.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s2.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static String reverse(String s2) {
        StringBuilder buf = new StringBuilder(s2);
        return buf.reverse().toString();
    }

    public static int ascii(String s2) {
        return s2.isEmpty() ? 0 : s2.codePointAt(0);
    }

    public static String repeat(String s2, int n) {
        if (n < 1) {
            return "";
        }
        return Strings.repeat(s2, n);
    }

    public static String space(int n) {
        return SqlFunctions.repeat(" ", n);
    }

    public static int strcmp(String s0, String s1) {
        return (int)Math.signum(s1.compareTo(s0));
    }

    public static String soundex(String s2) {
        return SOUNDEX.soundex(s2);
    }

    public static int difference(String s0, String s1) {
        String result0 = SqlFunctions.soundex(s0);
        String result1 = SqlFunctions.soundex(s1);
        for (int i = 0; i < 4; ++i) {
            if (result0.charAt(i) == result1.charAt(i)) continue;
            return i;
        }
        return 4;
    }

    public static String left(String s2, int n) {
        if (n <= 0) {
            return "";
        }
        int len = s2.length();
        if (n >= len) {
            return s2;
        }
        return s2.substring(0, n);
    }

    public static ByteString left(ByteString s2, int n) {
        if (n <= 0) {
            return ByteString.EMPTY;
        }
        int len = s2.length();
        if (n >= len) {
            return s2;
        }
        return s2.substring(0, n);
    }

    public static String right(String s2, int n) {
        if (n <= 0) {
            return "";
        }
        int len = s2.length();
        if (n >= len) {
            return s2;
        }
        return s2.substring(len - n);
    }

    public static ByteString right(ByteString s2, int n) {
        if (n <= 0) {
            return ByteString.EMPTY;
        }
        int len = s2.length();
        if (n >= len) {
            return s2;
        }
        return s2.substring(len - n);
    }

    public static @Nullable String charFromAscii(int n) {
        if (n < 0) {
            return null;
        }
        return String.valueOf(Character.toChars(n % 256));
    }

    public static String charFromUtf8(int n) {
        return String.valueOf(Character.toChars(n));
    }

    public static int octetLength(ByteString s2) {
        return s2.length();
    }

    public static int charLength(String s2) {
        return s2.length();
    }

    public static int bitLength(String s2) {
        return s2.getBytes(StandardCharsets.UTF_8).length * 8;
    }

    public static int bitLength(ByteString s2) {
        return s2.length() * 8;
    }

    public static String concat(String s0, String s1) {
        return s0 + s1;
    }

    public static @Nullable String concatWithNull(@Nullable String s0, @Nullable String s1) {
        if (s0 == null) {
            return s1;
        }
        if (s1 == null) {
            return s0;
        }
        return s0 + s1;
    }

    public static ByteString concat(ByteString s0, ByteString s1) {
        return s0.concat(s1);
    }

    public static String concatMulti(String ... args) {
        return String.join((CharSequence)"", args);
    }

    public static String concatMultiWithNull(String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg == null ? "" : arg);
        }
        return sb.toString();
    }

    public static String concatMultiWithSeparator(String ... args) {
        String sep = args[0] == null ? "" : args[0];
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (i < args.length - 1) {
                sb.append(args[i]).append(sep);
                continue;
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static String convertWithCharset(String s2, String srcCharset, String destCharset) {
        Charset src = SqlUtil.getCharset(srcCharset);
        Charset dest = SqlUtil.getCharset(destCharset);
        byte[] bytes = s2.getBytes(src);
        CharsetDecoder decoder = dest.newDecoder();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException ex) {
            throw Static.RESOURCE.charsetEncoding(s2, dest.name()).ex();
        }
    }

    public static String translateWithCharset(String s2, String transcodingName) {
        Charset charset = SqlUtil.getCharset(transcodingName);
        byte[] bytes = s2.getBytes(Charset.defaultCharset());
        CharsetDecoder decoder = charset.newDecoder();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException ex) {
            throw Static.RESOURCE.charsetEncoding(s2, charset.name()).ex();
        }
    }

    public static String rtrim(String s2) {
        return SqlFunctions.trim(false, true, " ", s2);
    }

    public static String ltrim(String s2) {
        return SqlFunctions.trim(true, false, " ", s2);
    }

    public static String trim(boolean left, boolean right, String seek, String s2) {
        return SqlFunctions.trim(left, right, seek, s2, true);
    }

    public static String trim(boolean left, boolean right, String seek, String s2, boolean strict) {
        if (strict && seek.length() != 1) {
            throw Static.RESOURCE.trimError().ex();
        }
        int j = s2.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return "";
                }
                if (seek.indexOf(s2.charAt(j - 1)) < 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return "";
                }
                if (seek.indexOf(s2.charAt(i)) < 0) break;
                ++i;
            }
        }
        return s2.substring(i, j);
    }

    public static ByteString trim(ByteString s2) {
        return SqlFunctions.trim_(s2, true, true);
    }

    public static ByteString rtrim(ByteString s2) {
        return SqlFunctions.trim_(s2, false, true);
    }

    private static ByteString trim_(ByteString s2, boolean left, boolean right) {
        int j = s2.length();
        if (right) {
            while (true) {
                if (j == 0) {
                    return ByteString.EMPTY;
                }
                if (s2.byteAt(j - 1) != 0) break;
                --j;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j) {
                    return ByteString.EMPTY;
                }
                if (s2.byteAt(i) != 0) break;
                ++i;
            }
        }
        return s2.substring(i, j);
    }

    public static String overlay(String s2, String r, int start) {
        return s2.substring(0, start - 1) + r + s2.substring(start - 1 + r.length());
    }

    public static String overlay(String s2, String r, int start, int length) {
        return s2.substring(0, start - 1) + r + s2.substring(start - 1 + length);
    }

    public static ByteString overlay(ByteString s2, ByteString r, int start) {
        return s2.substring(0, start - 1).concat(r).concat(s2.substring(start - 1 + r.length()));
    }

    public static ByteString overlay(ByteString s2, ByteString r, int start, int length) {
        return s2.substring(0, start - 1).concat(r).concat(s2.substring(start - 1 + length));
    }

    public static boolean like(String s2, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.matches(regex, s2);
    }

    public static boolean like(String s2, String pattern, String escape) {
        String regex = Like.sqlToRegexLike(pattern, escape);
        return Pattern.matches(regex, s2);
    }

    public static boolean ilike(String s2, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.compile(regex, 2).matcher(s2).matches();
    }

    public static boolean ilike(String s2, String pattern, String escape) {
        String regex = Like.sqlToRegexLike(pattern, escape);
        return Pattern.compile(regex, 2).matcher(s2).matches();
    }

    public static boolean rlike(String s2, String pattern) {
        return Pattern.compile(pattern).matcher(s2).find();
    }

    public static boolean similar(String s2, String pattern) {
        String regex = Like.sqlToRegexSimilar(pattern, null);
        return Pattern.matches(regex, s2);
    }

    public static boolean similar(String s2, String pattern, String escape) {
        String regex = Like.sqlToRegexSimilar(pattern, escape);
        return Pattern.matches(regex, s2);
    }

    public static boolean posixRegex(String s2, String regex, boolean caseSensitive) {
        Pattern pattern = Like.posixRegexToPattern(regex, caseSensitive);
        return pattern.matcher(s2).find();
    }

    public static boolean eq(BigDecimal b0, BigDecimal b1) {
        return b0.stripTrailingZeros().equals(b1.stripTrailingZeros());
    }

    public static boolean eq(@Nullable Object @Nullable [] b0, @Nullable Object @Nullable [] b1) {
        return Arrays.deepEquals(b0, b1);
    }

    public static boolean eq(Object b0, Object b1) {
        return b0.equals(b1);
    }

    public static boolean eq(String s0, String s1, Comparator<String> comparator) {
        return comparator.compare(s0, s1) == 0;
    }

    public static boolean eqAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass())) {
            if (BigDecimal.class.isInstance(b0)) {
                return SqlFunctions.eq((BigDecimal)b0, (BigDecimal)b1);
            }
            return b0.equals(b1);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.eq(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        return false;
    }

    private static boolean allAssignable(Class clazz, Object o0, Object o1) {
        return clazz.isInstance(o0) && clazz.isInstance(o1);
    }

    public static boolean ne(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) != 0;
    }

    public static boolean ne(Object b0, Object b1) {
        return !SqlFunctions.eq(b0, b1);
    }

    public static boolean ne(String s0, String s1, Comparator<String> comparator) {
        return !SqlFunctions.eq(s0, s1, comparator);
    }

    public static boolean neAny(Object b0, Object b1) {
        return !SqlFunctions.eqAny(b0, b1);
    }

    public static boolean lt(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) < 0;
    }

    public static boolean lt(String b0, String b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) < 0;
    }

    public static boolean lt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) < 0;
    }

    public static <T extends Comparable<T>> boolean ltNullable(T b0, T b1) {
        return b1 == null || b0 != null && b0.compareTo(b1) < 0;
    }

    public static boolean lt(byte b0, byte b1) {
        return b0 < b1;
    }

    public static boolean lt(char b0, char b1) {
        return b0 < b1;
    }

    public static boolean lt(short b0, short b1) {
        return b0 < b1;
    }

    public static boolean lt(int b0, int b1) {
        return b0 < b1;
    }

    public static boolean lt(long b0, long b1) {
        return b0 < b1;
    }

    public static boolean lt(float b0, float b1) {
        return b0 < b1;
    }

    public static boolean lt(double b0, double b1) {
        return b0 < b1;
    }

    public static boolean ltAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) < 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.lt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<", b0, b1);
    }

    public static boolean le(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) <= 0;
    }

    public static boolean le(String b0, String b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) <= 0;
    }

    public static boolean le(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean leAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) <= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.le(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<=", b0, b1);
    }

    public static boolean gt(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) > 0;
    }

    public static boolean gt(String b0, String b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) > 0;
    }

    public static boolean gt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) > 0;
    }

    public static <T extends Comparable<T>> boolean gtNullable(T b0, T b1) {
        return b1 == null || b0 != null && b0.compareTo(b1) > 0;
    }

    public static boolean gt(byte b0, byte b1) {
        return b0 > b1;
    }

    public static boolean gt(char b0, char b1) {
        return b0 > b1;
    }

    public static boolean gt(short b0, short b1) {
        return b0 > b1;
    }

    public static boolean gt(int b0, int b1) {
        return b0 > b1;
    }

    public static boolean gt(long b0, long b1) {
        return b0 > b1;
    }

    public static boolean gt(float b0, float b1) {
        return b0 > b1;
    }

    public static boolean gt(double b0, double b1) {
        return b0 > b1;
    }

    public static boolean gtAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) > 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.gt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">", b0, b1);
    }

    public static boolean ge(boolean b0, boolean b1) {
        return Boolean.compare(b0, b1) >= 0;
    }

    public static boolean ge(String b0, String b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(String b0, String b1, Comparator<String> comparator) {
        return comparator.compare(b0, b1) >= 0;
    }

    public static boolean ge(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean geAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) >= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.ge(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">=", b0, b1);
    }

    public static int plus(int b0, int b1) {
        return b0 + b1;
    }

    public static @PolyNull Integer plus(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Integer plus(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Integer plus(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 + b1);
    }

    public static @PolyNull Long plus(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 + b1.longValue());
    }

    public static @PolyNull Long plus(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() + b1);
    }

    public static @PolyNull BigDecimal plus(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.add(b1);
    }

    public static @PolyNull Object plusAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.plus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("+", b0, b1);
    }

    public static int minus(int b0, int b1) {
        return b0 - b1;
    }

    public static @PolyNull Integer minus(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Integer minus(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Integer minus(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 - b1);
    }

    public static @PolyNull Long minus(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 - b1.longValue());
    }

    public static @PolyNull Long minus(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() - b1);
    }

    public static @PolyNull BigDecimal minus(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.subtract(b1);
    }

    public static @PolyNull Object minusAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.minus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("-", b0, b1);
    }

    public static int divide(int b0, int b1) {
        return b0 / b1;
    }

    public static @PolyNull Integer divide(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Integer divide(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Integer divide(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 / b1);
    }

    public static @PolyNull Long divide(Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 / b1.longValue());
    }

    public static @PolyNull Long divide(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() / b1);
    }

    public static @PolyNull BigDecimal divide(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.divide(b1, MathContext.DECIMAL64);
    }

    public static @PolyNull Object divideAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.divide(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("/", b0, b1);
    }

    public static int divide(int b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).intValue();
    }

    public static long divide(long b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).longValue();
    }

    public static int multiply(int b0, int b1) {
        return b0 * b1;
    }

    public static @PolyNull Integer multiply(@PolyNull Integer b0, int b1) {
        return b0 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Integer multiply(int b0, @PolyNull Integer b1) {
        return b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Integer multiply(@PolyNull Integer b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(b0 * b1);
    }

    public static @PolyNull Long multiply(@PolyNull Long b0, @PolyNull Integer b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0 * b1.longValue());
    }

    public static @PolyNull Long multiply(@PolyNull Integer b0, @PolyNull Long b1) {
        return b0 == null || b1 == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(b0.longValue() * b1);
    }

    public static @PolyNull BigDecimal multiply(@PolyNull BigDecimal b0, @PolyNull BigDecimal b1) {
        return b0 == null || b1 == null ? (BigDecimal)Nullness.castNonNull(null) : b0.multiply(b1);
    }

    public static @PolyNull Object multiplyAny(@PolyNull Object b0, @PolyNull Object b1) {
        if (b0 == null || b1 == null) {
            return Nullness.castNonNull(null);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.multiply(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("*", b0, b1);
    }

    private static RuntimeException notArithmetic(String op, Object b0, Object b1) {
        return Static.RESOURCE.invalidTypesForArithmetic(b0.getClass().toString(), op, b1.getClass().toString()).ex();
    }

    private static RuntimeException notComparable(String op, Object b0, Object b1) {
        return Static.RESOURCE.invalidTypesForComparison(b0.getClass().toString(), op, b1.getClass().toString()).ex();
    }

    public static long bitAnd(long b0, long b1) {
        return b0 & b1;
    }

    public static ByteString bitAnd(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x & y));
    }

    public static long bitOr(long b0, long b1) {
        return b0 | b1;
    }

    public static ByteString bitOr(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x | y));
    }

    public static long bitXor(long b0, long b1) {
        return b0 ^ b1;
    }

    public static ByteString bitXor(ByteString b0, ByteString b1) {
        return SqlFunctions.binaryOperator(b0, b1, (x, y) -> (byte)(x ^ y));
    }

    private static ByteString binaryOperator(ByteString b0, ByteString b1, BinaryOperator<Byte> bitOp) {
        if (b0.length() == 0) {
            return b1;
        }
        if (b1.length() == 0) {
            return b0;
        }
        if (b0.length() != b1.length()) {
            throw Static.RESOURCE.differentLengthForBitwiseOperands(b0.length(), b1.length()).ex();
        }
        byte[] result = new byte[b0.length()];
        for (int i = 0; i < b0.length(); ++i) {
            result[i] = (Byte)bitOp.apply(b0.byteAt(i), b1.byteAt(i));
        }
        return new ByteString(result);
    }

    public static double exp(double b0) {
        return Math.exp(b0);
    }

    public static double exp(BigDecimal b0) {
        return Math.exp(b0.doubleValue());
    }

    public static double power(double b0, double b1) {
        return Math.pow(b0, b1);
    }

    public static double power(double b0, BigDecimal b1) {
        return Math.pow(b0, b1.doubleValue());
    }

    public static double power(BigDecimal b0, double b1) {
        return Math.pow(b0.doubleValue(), b1);
    }

    public static double power(BigDecimal b0, BigDecimal b1) {
        return Math.pow(b0.doubleValue(), b1.doubleValue());
    }

    public static double log(double d0, double d1) {
        return Math.log(d0) / Math.log(d1);
    }

    public static double log(double d0, BigDecimal d1) {
        return Math.log(d0) / Math.log(d1.doubleValue());
    }

    public static double log(BigDecimal d0, double d1) {
        return Math.log(d0.doubleValue()) / Math.log(d1);
    }

    public static double log(BigDecimal d0, BigDecimal d1) {
        return Math.log(d0.doubleValue()) / Math.log(d1.doubleValue());
    }

    public static byte mod(byte b0, byte b1) {
        return (byte)(b0 % b1);
    }

    public static short mod(short b0, short b1) {
        return (short)(b0 % b1);
    }

    public static int mod(int b0, int b1) {
        return b0 % b1;
    }

    public static long mod(long b0, long b1) {
        return b0 % b1;
    }

    public static BigDecimal mod(BigDecimal b0, int b1) {
        return SqlFunctions.mod(b0, BigDecimal.valueOf(b1));
    }

    public static BigDecimal mod(int b0, BigDecimal b1) {
        return SqlFunctions.mod(BigDecimal.valueOf(b0), b1);
    }

    public static BigDecimal mod(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        return bigDecimals[1];
    }

    public static double floor(double b0) {
        return Math.floor(b0);
    }

    public static float floor(float b0) {
        return (float)Math.floor(b0);
    }

    public static BigDecimal floor(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.FLOOR);
    }

    public static byte floor(byte b0, byte b1) {
        return (byte)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static short floor(short b0, short b1) {
        return (short)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static int floor(int b0, int b1) {
        int r = b0 % b1;
        if (r < 0) {
            r += b1;
        }
        return b0 - r;
    }

    public static long floor(long b0, long b1) {
        long r = b0 % b1;
        if (r < 0L) {
            r += b1;
        }
        return b0 - r;
    }

    public static BigDecimal floor(BigDecimal b0, int b1) {
        return SqlFunctions.floor(b0, BigDecimal.valueOf(b1));
    }

    public static int floor(int b0, BigDecimal b1) {
        return SqlFunctions.floor(b0, b1.intValue());
    }

    public static BigDecimal floor(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() < 0) {
            r = r.add(b1);
        }
        return b0.subtract(r);
    }

    public static double ceil(double b0) {
        return Math.ceil(b0);
    }

    public static float ceil(float b0) {
        return (float)Math.ceil(b0);
    }

    public static BigDecimal ceil(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.CEILING);
    }

    public static byte ceil(byte b0, byte b1) {
        return SqlFunctions.floor((byte)(b0 + b1 - 1), b1);
    }

    public static short ceil(short b0, short b1) {
        return SqlFunctions.floor((short)(b0 + b1 - 1), b1);
    }

    public static int ceil(int b0, int b1) {
        int r = b0 % b1;
        if (r > 0) {
            r -= b1;
        }
        return b0 - r;
    }

    public static long ceil(long b0, long b1) {
        return SqlFunctions.floor(b0 + b1 - 1L, b1);
    }

    public static BigDecimal ceil(BigDecimal b0, int b1) {
        return SqlFunctions.ceil(b0, BigDecimal.valueOf(b1));
    }

    public static int ceil(int b0, BigDecimal b1) {
        return SqlFunctions.ceil(b0, b1.intValue());
    }

    public static BigDecimal ceil(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() > 0) {
            r = r.subtract(b1);
        }
        return b0.subtract(r);
    }

    public static byte abs(byte b0) {
        return (byte)Math.abs(b0);
    }

    public static short abs(short b0) {
        return (short)Math.abs(b0);
    }

    public static int abs(int b0) {
        return Math.abs(b0);
    }

    public static long abs(long b0) {
        return Math.abs(b0);
    }

    public static float abs(float b0) {
        return Math.abs(b0);
    }

    public static double abs(double b0) {
        return Math.abs(b0);
    }

    public static BigDecimal abs(BigDecimal b0) {
        return b0.abs();
    }

    public static double acos(BigDecimal b0) {
        return Math.acos(b0.doubleValue());
    }

    public static double acos(double b0) {
        return Math.acos(b0);
    }

    public static double acosh(BigDecimal b0) {
        return SqlFunctions.acosh(b0.doubleValue());
    }

    public static double acosh(double b0) {
        if (b0 < 1.0) {
            throw new IllegalArgumentException("Input parameter of acosh cannot be less than 1!");
        }
        return Math.log(Math.sqrt(b0 * b0 - 1.0) + b0);
    }

    public static double asin(BigDecimal b0) {
        return Math.asin(b0.doubleValue());
    }

    public static double asin(double b0) {
        return Math.asin(b0);
    }

    public static double asinh(BigDecimal b0) {
        return SqlFunctions.asinh(b0.doubleValue());
    }

    public static double asinh(double b0) {
        double sign;
        if (Double.doubleToRawLongBits(b0) < 0L) {
            b0 = Math.abs(b0);
            sign = -1.0;
        } else {
            sign = 1.0;
        }
        return sign * Math.log(Math.sqrt(b0 * b0 + 1.0) + b0);
    }

    public static double atan(BigDecimal b0) {
        return Math.atan(b0.doubleValue());
    }

    public static double atan(double b0) {
        return Math.atan(b0);
    }

    public static double atan2(double b0, BigDecimal b1) {
        return Math.atan2(b0, b1.doubleValue());
    }

    public static double atan2(BigDecimal b0, double b1) {
        return Math.atan2(b0.doubleValue(), b1);
    }

    public static double atan2(BigDecimal b0, BigDecimal b1) {
        return Math.atan2(b0.doubleValue(), b1.doubleValue());
    }

    public static double atan2(double b0, double b1) {
        return Math.atan2(b0, b1);
    }

    public static double atanh(BigDecimal b) {
        return SqlFunctions.atanh(b.doubleValue());
    }

    public static double atanh(double b) {
        double mult;
        if (Math.abs(b) >= 1.0) {
            throw new IllegalArgumentException("Input parameter of atanh cannot be out of the range (-1, 1)!");
        }
        if (Double.doubleToRawLongBits(b) < 0L) {
            b = Math.abs(b);
            mult = -0.5;
        } else {
            mult = 0.5;
        }
        return mult * Math.log((1.0 + b) / (1.0 - b));
    }

    public static double cbrt(BigDecimal b) {
        return SqlFunctions.cbrt(b.doubleValue());
    }

    public static double cbrt(double b) {
        return Math.cbrt(b);
    }

    public static double cos(BigDecimal b0) {
        return Math.cos(b0.doubleValue());
    }

    public static double cos(double b0) {
        return Math.cos(b0);
    }

    public static double cosh(BigDecimal b) {
        return SqlFunctions.cosh(b.doubleValue());
    }

    public static double cosh(double b) {
        return Math.cosh(b);
    }

    public static double cot(BigDecimal b0) {
        return 1.0 / Math.tan(b0.doubleValue());
    }

    public static double cot(double b0) {
        return 1.0 / Math.tan(b0);
    }

    public static double coth(BigDecimal b0) {
        return 1.0 / Math.tanh(b0.doubleValue());
    }

    public static double coth(double b0) {
        return 1.0 / Math.tanh(b0);
    }

    public static double csch(BigDecimal b0) {
        return 1.0 / Math.sinh(b0.doubleValue());
    }

    public static double csch(double b0) {
        return 1.0 / Math.sinh(b0);
    }

    public static double degrees(BigDecimal b0) {
        return Math.toDegrees(b0.doubleValue());
    }

    public static double degrees(double b0) {
        return Math.toDegrees(b0);
    }

    public static double radians(BigDecimal b0) {
        return Math.toRadians(b0.doubleValue());
    }

    public static double radians(double b0) {
        return Math.toRadians(b0);
    }

    public static double sech(BigDecimal b0) {
        return 1.0 / Math.cosh(b0.doubleValue());
    }

    public static double sech(double b0) {
        return 1.0 / Math.cosh(b0);
    }

    public static int sround(int b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static int sround(int b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long sround(long b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static long sround(long b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal sround(BigDecimal b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static BigDecimal sround(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.HALF_UP).movePointLeft(b1);
    }

    public static double sround(double b0) {
        return SqlFunctions.sround(b0, 0);
    }

    public static double sround(double b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int struncate(int b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static int struncate(int b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long struncate(long b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static long struncate(long b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal struncate(BigDecimal b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static BigDecimal struncate(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.DOWN).movePointLeft(b1);
    }

    public static double struncate(double b0) {
        return SqlFunctions.struncate(b0, 0);
    }

    public static double struncate(double b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int sign(int b0) {
        return Integer.signum(b0);
    }

    public static long sign(long b0) {
        return Long.signum(b0);
    }

    public static BigDecimal sign(BigDecimal b0) {
        return BigDecimal.valueOf(b0.signum());
    }

    public static double sign(double b0) {
        return Math.signum(b0);
    }

    public static double sin(BigDecimal b0) {
        return Math.sin(b0.doubleValue());
    }

    public static double sin(double b0) {
        return Math.sin(b0);
    }

    public static double sinh(BigDecimal b) {
        return SqlFunctions.sinh(b.doubleValue());
    }

    public static double sinh(double b) {
        return Math.sinh(b);
    }

    public static double tan(BigDecimal b0) {
        return Math.tan(b0.doubleValue());
    }

    public static double tan(double b0) {
        return Math.tan(b0);
    }

    public static double tanh(BigDecimal b) {
        return SqlFunctions.tanh(b.doubleValue());
    }

    public static double tanh(double b) {
        return Math.tanh(b);
    }

    public static double csc(BigDecimal b0) {
        return 1.0 / Math.sin(b0.doubleValue());
    }

    public static double csc(double b0) {
        return 1.0 / Math.sin(b0);
    }

    public static double sec(BigDecimal b0) {
        return 1.0 / Math.cos(b0.doubleValue());
    }

    public static double sec(double b0) {
        return 1.0 / Math.cos(b0);
    }

    public static <T extends Comparable<T>> T lesser(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T least(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static boolean greater(boolean b0, boolean b1) {
        return b0 || b1;
    }

    public static boolean lesser(boolean b0, boolean b1) {
        return b0 && b1;
    }

    public static byte greater(byte b0, byte b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static byte lesser(byte b0, byte b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static char greater(char b0, char b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static char lesser(char b0, char b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static short greater(short b0, short b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static short lesser(short b0, short b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static int greater(int b0, int b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static int lesser(int b0, int b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static long greater(long b0, long b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static long lesser(long b0, long b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static float greater(float b0, float b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static float lesser(float b0, float b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static double greater(double b0, double b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static double lesser(double b0, double b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greater(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greatest(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static String toString(float x) {
        if (x == 0.0f) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL32).stripTrailingZeros();
        String s2 = bigDecimal.toString();
        return PATTERN_0_STAR_E.matcher(s2).replaceAll("E").replace("E+", "E");
    }

    public static String toString(double x) {
        if (x == 0.0) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL64).stripTrailingZeros();
        String s2 = bigDecimal.toString();
        return PATTERN_0_STAR_E.matcher(s2).replaceAll("E").replace("E+", "E");
    }

    public static String toString(BigDecimal x) {
        String s2 = x.toString();
        if (s2.equals("0")) {
            return s2;
        }
        if (s2.startsWith("0.")) {
            return s2.substring(1);
        }
        if (s2.startsWith("-0.")) {
            return "-" + s2.substring(2);
        }
        return s2;
    }

    public static String toString(boolean x) {
        return x ? "TRUE" : "FALSE";
    }

    @NonDeterministic
    private static Object cannotConvert(Object o, Class toType) {
        throw Static.RESOURCE.cannotConvert(String.valueOf(o), toType.toString()).ex();
    }

    public static boolean toBoolean(String s2) {
        if ((s2 = SqlFunctions.trim(true, true, " ", s2)).equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s2.equalsIgnoreCase("FALSE")) {
            return false;
        }
        throw Static.RESOURCE.invalidCharacterForCast(s2).ex();
    }

    public static boolean toBoolean(Number number) {
        return !number.equals(0);
    }

    public static boolean toBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : (o instanceof Number ? SqlFunctions.toBoolean((Number)o) : (o instanceof String ? SqlFunctions.toBoolean((String)o) : (Boolean)SqlFunctions.cannotConvert(o, Boolean.TYPE)));
    }

    public static byte toByte(Object o) {
        return o instanceof Byte ? (Byte)o : (o instanceof Number ? SqlFunctions.toByte((Number)o) : Byte.parseByte(o.toString()));
    }

    public static byte toByte(Number number) {
        return number.byteValue();
    }

    public static char toChar(String s2) {
        return s2.charAt(0);
    }

    public static Character toCharBoxed(String s2) {
        return Character.valueOf(s2.charAt(0));
    }

    public static short toShort(String s2) {
        return Short.parseShort(s2.trim());
    }

    public static short toShort(Number number) {
        return number.shortValue();
    }

    public static short toShort(Object o) {
        return o instanceof Short ? (Short)o : (o instanceof Number ? SqlFunctions.toShort((Number)o) : (o instanceof String ? SqlFunctions.toShort((String)o) : (Short)SqlFunctions.cannotConvert(o, Short.TYPE)));
    }

    public static int toInt(java.sql.Date v) {
        return SqlFunctions.toInt(v, LOCAL_TZ);
    }

    public static int toInt(java.sql.Date v, TimeZone timeZone) {
        return DateTimeUtils.sqlDateToUnixDate(v, timeZone);
    }

    public static @PolyNull Integer toIntOptional(@PolyNull java.sql.Date v) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static @PolyNull Integer toIntOptional(@PolyNull java.sql.Date v, TimeZone timeZone) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v, timeZone));
    }

    public static int toInt(Time v) {
        return DateTimeUtils.sqlTimeToUnixTime(v, LOCAL_TZ);
    }

    public static @PolyNull Integer toIntOptional(@PolyNull Time v) {
        return v == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static int toInt(String s2) {
        return Integer.parseInt(s2.trim());
    }

    public static int toInt(Number number) {
        return number.intValue();
    }

    public static int toInt(Object o) {
        return o instanceof Integer ? (Integer)o : (o instanceof Number ? SqlFunctions.toInt((Number)o) : (o instanceof String ? SqlFunctions.toInt((String)o) : (o instanceof java.sql.Date ? SqlFunctions.toInt((java.sql.Date)o) : (o instanceof Time ? SqlFunctions.toInt((Time)o) : (Integer)SqlFunctions.cannotConvert(o, Integer.TYPE)))));
    }

    public static @PolyNull Integer toIntOptional(@PolyNull Object o) {
        return o == null ? (Integer)Nullness.castNonNull(null) : Integer.valueOf(SqlFunctions.toInt(o));
    }

    public static long toLong(Date v) {
        return DateTimeUtils.utilDateToUnixTimestamp(v, LOCAL_TZ);
    }

    public static long toLong(Timestamp v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(Timestamp v, TimeZone timeZone) {
        return DateTimeUtils.sqlTimestampToUnixTimestamp(v, timeZone);
    }

    public static @PolyNull Long toLongOptional(@PolyNull Timestamp v) {
        return v == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(SqlFunctions.toLong(v, LOCAL_TZ));
    }

    public static @PolyNull Long toLongOptional(@PolyNull Timestamp v, TimeZone timeZone) {
        if (v == null) {
            return Nullness.castNonNull(null);
        }
        return SqlFunctions.toLong(v, timeZone);
    }

    public static long toLong(String s2) {
        if (s2.startsWith("199") && s2.contains(":")) {
            return Timestamp.valueOf(s2).getTime();
        }
        return Long.parseLong(s2.trim());
    }

    public static long toLong(Number number) {
        return number.longValue();
    }

    public static long toLong(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof Number ? SqlFunctions.toLong((Number)o) : (o instanceof String ? SqlFunctions.toLong((String)o) : (o instanceof java.sql.Date ? (long)SqlFunctions.toInt((java.sql.Date)o) : (o instanceof Time ? (long)SqlFunctions.toInt((Time)o) : (o instanceof Timestamp ? SqlFunctions.toLong((Timestamp)o) : (o instanceof Date ? SqlFunctions.toLong((Date)o) : (Long)SqlFunctions.cannotConvert(o, Long.TYPE)))))));
    }

    public static @PolyNull Long toLongOptional(@PolyNull Object o) {
        return o == null ? (Long)Nullness.castNonNull(null) : Long.valueOf(SqlFunctions.toLong(o));
    }

    public static float toFloat(String s2) {
        return Float.parseFloat(s2.trim());
    }

    public static float toFloat(Number number) {
        return number.floatValue();
    }

    public static float toFloat(Object o) {
        return o instanceof Float ? ((Float)o).floatValue() : (o instanceof Number ? SqlFunctions.toFloat((Number)o) : (o instanceof String ? SqlFunctions.toFloat((String)o) : ((Float)SqlFunctions.cannotConvert(o, Float.TYPE)).floatValue()));
    }

    public static double toDouble(String s2) {
        return Double.parseDouble(s2.trim());
    }

    public static double toDouble(Number number) {
        return number.doubleValue();
    }

    public static double toDouble(Object o) {
        return o instanceof Double ? (Double)o : (o instanceof Number ? SqlFunctions.toDouble((Number)o) : (o instanceof String ? SqlFunctions.toDouble((String)o) : (Double)SqlFunctions.cannotConvert(o, Double.TYPE)));
    }

    public static BigDecimal toBigDecimal(String s2) {
        return new BigDecimal(s2.trim());
    }

    public static BigDecimal toBigDecimal(Number number) {
        return number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Long ? new BigDecimal(number.longValue()) : new BigDecimal(number.doubleValue())));
    }

    public static BigDecimal toBigDecimal(Object o) {
        return o instanceof Number ? SqlFunctions.toBigDecimal((Number)o) : SqlFunctions.toBigDecimal(o.toString());
    }

    public static java.sql.Date internalToDate(int v) {
        LocalDate date = LocalDate.ofEpochDay(v);
        return java.sql.Date.valueOf(date);
    }

    public static @PolyNull java.sql.Date internalToDate(@PolyNull Integer v) {
        return v == null ? (java.sql.Date)Nullness.castNonNull(null) : SqlFunctions.internalToDate((int)v);
    }

    public static Time internalToTime(int v) {
        return new Time(v - LOCAL_TZ.getOffset(v));
    }

    public static @PolyNull Time internalToTime(@PolyNull Integer v) {
        return v == null ? (Time)Nullness.castNonNull(null) : SqlFunctions.internalToTime((int)v);
    }

    public static @PolyNull Integer toTimeWithLocalTimeZone(@PolyNull String v) {
        if (v == null) {
            return Nullness.castNonNull(null);
        }
        return new TimeWithTimeZoneString(v).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimeString().getMillisOfDay();
    }

    public static @PolyNull Integer toTimeWithLocalTimeZone(@PolyNull String v, TimeZone timeZone) {
        if (v == null) {
            return Nullness.castNonNull(null);
        }
        return new TimeWithTimeZoneString(v + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimeString().getMillisOfDay();
    }

    public static int timeWithLocalTimeZoneToTime(int v, TimeZone timeZone) {
        return TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(timeZone).getLocalTimeString().getMillisOfDay();
    }

    public static long timeWithLocalTimeZoneToTimestamp(String date, int v, TimeZone timeZone) {
        TimeWithTimeZoneString tTZ = TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(DateTimeUtils.UTC_ZONE);
        return new TimestampWithTimeZoneString(date + " " + tTZ.toString()).withTimeZone(timeZone).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static long timeWithLocalTimeZoneToTimestampWithLocalTimeZone(String date, int v) {
        TimeWithTimeZoneString tTZ = TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(DateTimeUtils.UTC_ZONE);
        return new TimestampWithTimeZoneString(date + " " + tTZ.toString()).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static String timeWithLocalTimeZoneToString(int v, TimeZone timeZone) {
        return TimeWithTimeZoneString.fromMillisOfDay(v).withTimeZone(timeZone).toString();
    }

    private static String internalFormatDatetime(String fmtString, Date date) {
        StringBuilder sb = new StringBuilder();
        List<FormatElement> elements = FormatModels.BIG_QUERY.parse(fmtString);
        elements.forEach(ele -> ele.format(sb, date));
        return sb.toString();
    }

    public static String formatTimestamp(DataContext ctx, String fmtString, long timestamp) {
        return SqlFunctions.internalFormatDatetime(fmtString, SqlFunctions.internalToTimestamp(timestamp));
    }

    public static String toChar(long timestamp, String pattern) {
        List<FormatElement> elements = FormatModels.POSTGRESQL.parse(pattern);
        StringBuilder sb = new StringBuilder();
        elements.forEach(ele -> ele.format(sb, SqlFunctions.internalToTimestamp(timestamp)));
        return sb.toString().trim();
    }

    public static String formatDate(DataContext ctx, String fmtString, int date) {
        return SqlFunctions.internalFormatDatetime(fmtString, SqlFunctions.internalToDate(date));
    }

    public static String formatTime(DataContext ctx, String fmtString, int time) {
        return SqlFunctions.internalFormatDatetime(fmtString, SqlFunctions.internalToTime(time));
    }

    private static String parseDatetimePattern(String fmtString) {
        StringBuilder sb = new StringBuilder();
        List<FormatElement> elements = FormatModels.BIG_QUERY.parse(fmtString);
        elements.forEach(ele -> ele.toPattern(sb));
        return sb.toString();
    }

    private static long internalParseDatetime(String fmtString, String datetime) {
        return SqlFunctions.internalParseDatetime(fmtString, datetime, DateTimeUtils.DEFAULT_ZONE);
    }

    private static long internalParseDatetime(String fmt, String datetime, TimeZone tz) {
        String javaFmt = SqlFunctions.parseDatetimePattern(fmt);
        SimpleDateFormat parser = new SimpleDateFormat(javaFmt, Locale.ENGLISH);
        ParsePosition pos = new ParsePosition(0);
        parser.setLenient(false);
        parser.setCalendar(Calendar.getInstance(tz, Locale.ROOT));
        Date parsed = ((DateFormat)parser).parse(datetime, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != datetime.length()) {
            SQLException e = new SQLException(String.format(Locale.ROOT, "Invalid format: '%s' for datetime string: '%s'.", fmt, datetime));
            throw Util.toUnchecked(e);
        }
        long millisSinceEpoch = parsed.getTime();
        return millisSinceEpoch;
    }

    public static int parseDate(String fmtString, String date) {
        long millisSinceEpoch = SqlFunctions.internalParseDatetime(fmtString, date);
        return SqlFunctions.toInt(new java.sql.Date(millisSinceEpoch));
    }

    public static long parseDatetime(String fmtString, String datetime) {
        long millisSinceEpoch = SqlFunctions.internalParseDatetime(fmtString, datetime);
        return SqlFunctions.toLong(new Timestamp(millisSinceEpoch));
    }

    public static int parseTime(String fmtString, String time) {
        long millisSinceEpoch = SqlFunctions.internalParseDatetime(fmtString, time);
        return SqlFunctions.toInt(new Time(millisSinceEpoch));
    }

    public static long parseTimestamp(String fmtString, String timestamp) {
        return SqlFunctions.parseTimestamp(fmtString, timestamp, "UTC");
    }

    public static long parseTimestamp(String fmtString, String timestamp, String timeZone) {
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        long millisSinceEpoch = SqlFunctions.internalParseDatetime(fmtString, timestamp, tz);
        return SqlFunctions.toLong(new Timestamp(millisSinceEpoch), tz);
    }

    public static Timestamp internalToTimestamp(long v) {
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(Math.floorDiv(v, 1000L), (int)(Math.floorMod(v, 1000L) * 1000000L), ZoneOffset.UTC);
        return Timestamp.valueOf(dateTime);
    }

    public static @PolyNull Timestamp internalToTimestamp(@PolyNull Long v) {
        return v == null ? (Timestamp)Nullness.castNonNull(null) : SqlFunctions.internalToTimestamp((long)v);
    }

    public static int timestampWithLocalTimeZoneToDate(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalDateString().getDaysSinceEpoch();
    }

    public static int timestampWithLocalTimeZoneToTime(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalTimeString().getMillisOfDay();
    }

    public static long timestampWithLocalTimeZoneToTimestamp(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static String timestampWithLocalTimeZoneToString(long v, TimeZone timeZone) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).withTimeZone(timeZone).toString();
    }

    public static int timestampWithLocalTimeZoneToTimeWithLocalTimeZone(long v) {
        return TimestampWithTimeZoneString.fromMillisSinceEpoch(v).getLocalTimeString().getMillisOfDay();
    }

    public static long timestampSeconds(long v) {
        return v * 1000L;
    }

    public static long timestampMillis(long v) {
        return v;
    }

    public static long timestampMicros(long v) {
        return v / 1000L;
    }

    public static long unixSeconds(long v) {
        return v / 1000L;
    }

    public static long unixMillis(long v) {
        return v;
    }

    public static long unixMicros(long v) {
        return v * 1000L;
    }

    public static int dateFromUnixDate(int v) {
        return v;
    }

    public static int unixDate(int v) {
        return v;
    }

    public static int date(int year, int month, int day) {
        return (int)LocalDate.of(year, month, day).toEpochDay();
    }

    public static int date(long timestampMillis) {
        return (int)(timestampMillis / 86400000L);
    }

    public static int date(long timestampMillis, String timeZone) {
        return (int)OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), ZoneId.of(timeZone)).toLocalDate().toEpochDay();
    }

    public static long datetime(int year, int month, int day, int hour, int minute, int second) {
        return LocalDateTime.of(year, month, day, hour, minute, second).toEpochSecond(ZoneOffset.UTC) * 1000L;
    }

    public static long datetime(int daysSinceEpoch) {
        return (long)daysSinceEpoch * 86400000L;
    }

    public static long datetime(int daysSinceEpoch, int millisSinceMidnight) {
        return (long)daysSinceEpoch * 86400000L + (long)millisSinceMidnight;
    }

    public static long datetime(long millisSinceEpoch) {
        return millisSinceEpoch;
    }

    public static long datetime(long millisSinceEpoch, String timeZone) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(millisSinceEpoch), ZoneId.of(timeZone)).atZoneSimilarLocal(ZoneId.of("UTC")).toInstant().toEpochMilli();
    }

    public static long timestamp(String expression) {
        return SqlFunctions.parseBigQueryTimestampLiteral(expression).toInstant().toEpochMilli();
    }

    public static long timestamp(String expression, String timeZone) {
        return SqlFunctions.parseBigQueryTimestampLiteral(expression).atZoneSimilarLocal(ZoneId.of(timeZone)).toInstant().toEpochMilli();
    }

    private static OffsetDateTime parseBigQueryTimestampLiteral(String expression) {
        try {
            return OffsetDateTime.parse(expression, BIG_QUERY_TIMESTAMP_LITERAL_FORMATTER);
        }
        catch (DateTimeParseException dateTimeParseException) {
            if (IS_JDK_8 && expression.matches(".*[+-][0-9][0-9]$")) {
                try {
                    expression = expression + ":00";
                    return OffsetDateTime.parse(expression, BIG_QUERY_TIMESTAMP_LITERAL_FORMATTER);
                }
                catch (DateTimeParseException dateTimeParseException2) {
                    // empty catch block
                }
            }
            try {
                return LocalDateTime.parse(expression, BIG_QUERY_TIMESTAMP_LITERAL_FORMATTER).atOffset(ZoneOffset.UTC);
            }
            catch (DateTimeParseException e2) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not parse BigQuery timestamp literal: %s", expression), e2);
            }
        }
    }

    public static long timestamp(int days) {
        return (long)days * 86400000L;
    }

    public static long timestamp(int days, String timeZone) {
        LocalDateTime localDateTime = LocalDateTime.of(LocalDate.ofEpochDay(days), LocalTime.MIDNIGHT);
        ZoneOffset zoneOffset = ZoneId.of(timeZone).getRules().getOffset(localDateTime);
        return OffsetDateTime.of(localDateTime, zoneOffset).toInstant().toEpochMilli();
    }

    public static long timestamp(long millisSinceEpoch) {
        return millisSinceEpoch;
    }

    public static long timestamp(long millisSinceEpoch, String timeZone) {
        Instant instant = Instant.ofEpochMilli(millisSinceEpoch);
        ZoneId utcZone = ZoneId.of("UTC");
        return OffsetDateTime.ofInstant(instant, utcZone).atZoneSimilarLocal(ZoneId.of(timeZone)).toInstant().toEpochMilli();
    }

    public static int time(int hour, int minute, int second) {
        return (int)((long)LocalTime.of(hour, minute, second).toSecondOfDay() * 1000L);
    }

    public static int time(long timestampMillis) {
        return (int)(timestampMillis % 86400000L);
    }

    public static int time(long timestampMillis, String timeZone) {
        Instant instant = Instant.ofEpochMilli(timestampMillis);
        ZoneId zoneId = ZoneId.of(timeZone);
        return (int)(OffsetDateTime.ofInstant(instant, zoneId).toLocalTime().toNanoOfDay() / 1000000L);
    }

    public static @PolyNull Long toTimestampWithLocalTimeZone(@PolyNull String v) {
        if (v == null) {
            return Nullness.castNonNull(null);
        }
        return new TimestampWithTimeZoneString(v).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static @PolyNull Long toTimestampWithLocalTimeZone(@PolyNull String v, TimeZone timeZone) {
        if (v == null) {
            return Nullness.castNonNull(null);
        }
        return new TimestampWithTimeZoneString(v + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString().getMillisSinceEpoch();
    }

    public static @PolyNull String truncate(@PolyNull String s2, int maxLength) {
        if (s2 == null) {
            return s2;
        }
        if (s2.length() > maxLength) {
            return s2.substring(0, maxLength);
        }
        return s2;
    }

    public static @PolyNull String truncateOrPad(@PolyNull String s2, int maxLength) {
        if (s2 == null) {
            return s2;
        }
        int length = s2.length();
        if (length > maxLength) {
            return s2.substring(0, maxLength);
        }
        return length < maxLength ? Spaces.padRight(s2, maxLength) : s2;
    }

    public static @PolyNull ByteString truncate(@PolyNull ByteString s2, int maxLength) {
        if (s2 == null) {
            return s2;
        }
        if (s2.length() > maxLength) {
            return s2.substring(0, maxLength);
        }
        return s2;
    }

    public static @PolyNull ByteString truncateOrPad(@PolyNull ByteString s2, int maxLength) {
        if (s2 == null) {
            return s2;
        }
        int length = s2.length();
        if (length > maxLength) {
            return s2.substring(0, maxLength);
        }
        if (length < maxLength) {
            return s2.concat(new ByteString(new byte[maxLength - length]));
        }
        return s2;
    }

    public static int position(String seek, String s2) {
        return s2.indexOf(seek) + 1;
    }

    public static int position(ByteString seek, ByteString s2) {
        return s2.indexOf(seek) + 1;
    }

    public static int position(String seek, String s2, int from) {
        if (from == 0) {
            throw Static.RESOURCE.fromNotZero().ex();
        }
        if (from > 0) {
            return SqlFunctions.positionForwards(seek, s2, from);
        }
        return SqlFunctions.positionBackwards(seek, s2, from += s2.length());
    }

    public static int position(ByteString seek, ByteString s2, int from) {
        if (from == 0) {
            throw Static.RESOURCE.fromNotZero().ex();
        }
        if (from > 0) {
            return SqlFunctions.positionForwards(seek, s2, from);
        }
        return SqlFunctions.positionBackwards(seek, s2, from += s2.length());
    }

    private static int positionForwards(String seek, String s2, int from) {
        int from0 = from - 1;
        if (from0 >= s2.length()) {
            return 0;
        }
        return s2.indexOf(seek, from0) + 1;
    }

    private static int positionForwards(ByteString seek, ByteString s2, int from) {
        int from0 = from - 1;
        if (from0 >= s2.length()) {
            return 0;
        }
        return s2.indexOf(seek, from0) + 1;
    }

    private static int positionBackwards(String seek, String s2, int rightIndex) {
        if (rightIndex <= 0) {
            return 0;
        }
        int lastIndex = s2.lastIndexOf(seek) + 1;
        while (lastIndex > rightIndex + 1) {
            if ((lastIndex = s2.substring(0, lastIndex - 1).lastIndexOf(seek) + 1) != 0) continue;
            return 0;
        }
        return lastIndex;
    }

    private static int positionBackwards(ByteString seek, ByteString s2, int rightIndex) {
        int lastIndex;
        int indexOf;
        if (rightIndex <= 0) {
            return 0;
        }
        for (lastIndex = 0; lastIndex < rightIndex && (indexOf = s2.substring(lastIndex).indexOf(seek) + 1) != 0 && lastIndex + indexOf <= rightIndex + 1; lastIndex += indexOf) {
        }
        return lastIndex;
    }

    public static int position(String seek, String s2, int from, int occurrence) {
        if (from == 0) {
            throw Static.RESOURCE.fromNotZero().ex();
        }
        if (occurrence == 0) {
            throw Static.RESOURCE.occurrenceNotZero().ex();
        }
        if (from > 0) {
            --from;
            for (int i = 0; i < occurrence; ++i) {
                ++from;
                if ((from = SqlFunctions.positionForwards(seek, s2, from)) != 0) continue;
                return 0;
            }
        } else {
            from += s2.length() + 1;
            ++from;
            for (int i = 0; i < occurrence; ++i) {
                --from;
                if ((from = SqlFunctions.positionBackwards(seek, s2, from - 1)) != 0) continue;
                return 0;
            }
        }
        return from;
    }

    public static int position(ByteString seek, ByteString s2, int from, int occurrence) {
        if (from == 0) {
            throw Static.RESOURCE.fromNotZero().ex();
        }
        if (occurrence == 0) {
            throw Static.RESOURCE.occurrenceNotZero().ex();
        }
        if (from > 0) {
            --from;
            for (int i = 0; i < occurrence; ++i) {
                ++from;
                if ((from = SqlFunctions.positionForwards(seek, s2, from)) != 0) continue;
                return 0;
            }
        } else {
            from += s2.length() + 1;
            ++from;
            for (int i = 0; i < occurrence; ++i) {
                --from;
                if ((from = SqlFunctions.positionBackwards(seek, s2, from - 1)) != 0) continue;
                return 0;
            }
        }
        return from;
    }

    public static long round(long v, long x) {
        return SqlFunctions.truncate(v + x / 2L, x);
    }

    public static long truncate(long v, long x) {
        long remainder = v % x;
        if (remainder < 0L) {
            remainder += x;
        }
        return v - remainder;
    }

    public static int round(int v, int x) {
        return SqlFunctions.truncate(v + x / 2, x);
    }

    public static int truncate(int v, int x) {
        int remainder = v % x;
        if (remainder < 0) {
            remainder += x;
        }
        return v - remainder;
    }

    public static String dayNameWithTimestamp(long timestamp, Locale locale) {
        return SqlFunctions.timeStampToLocalDate(timestamp).format(ROOT_DAY_FORMAT.withLocale(locale));
    }

    public static String dayNameWithDate(int date, Locale locale) {
        return SqlFunctions.dateToLocalDate(date).format(ROOT_DAY_FORMAT.withLocale(locale));
    }

    public static String monthNameWithTimestamp(long timestamp, Locale locale) {
        return SqlFunctions.timeStampToLocalDate(timestamp).format(ROOT_MONTH_FORMAT.withLocale(locale));
    }

    public static String monthNameWithDate(int date, Locale locale) {
        return SqlFunctions.dateToLocalDate(date).format(ROOT_MONTH_FORMAT.withLocale(locale));
    }

    private static LocalDate dateToLocalDate(int date) {
        int y0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.YEAR, date);
        int m0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.MONTH, date);
        int d0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.DAY, date);
        return LocalDate.of(y0, m0, d0);
    }

    private static LocalDate timeStampToLocalDate(long timestamp) {
        int date = SqlFunctions.timestampToDate(timestamp);
        return SqlFunctions.dateToLocalDate(date);
    }

    public static int timestampToDate(long timestamp) {
        return (int)(timestamp / 86400000L);
    }

    public static int timestampToTime(long timestamp) {
        return (int)(timestamp % 86400000L);
    }

    @NonDeterministic
    public static long currentTimestamp(DataContext root) {
        return (Long)DataContext.Variable.CURRENT_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int currentTime(DataContext root) {
        int time = SqlFunctions.timestampToTime(SqlFunctions.currentTimestamp(root));
        if (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        return time;
    }

    @NonDeterministic
    public static int currentDate(DataContext root) {
        long timestamp = SqlFunctions.currentTimestamp(root);
        int date = SqlFunctions.timestampToDate(timestamp);
        int time = SqlFunctions.timestampToTime(timestamp);
        if (time < 0) {
            --date;
        }
        return date;
    }

    @NonDeterministic
    public static long localTimestamp(DataContext root) {
        return (Long)DataContext.Variable.LOCAL_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int localTime(DataContext root) {
        return SqlFunctions.timestampToTime(SqlFunctions.localTimestamp(root));
    }

    @NonDeterministic
    public static TimeZone timeZone(DataContext root) {
        return (TimeZone)DataContext.Variable.TIME_ZONE.get(root);
    }

    @Deterministic
    public static String user(DataContext root) {
        return (String)Objects.requireNonNull(DataContext.Variable.USER.get(root));
    }

    @Deterministic
    public static String systemUser(DataContext root) {
        return (String)Objects.requireNonNull(DataContext.Variable.SYSTEM_USER.get(root));
    }

    @NonDeterministic
    public static Locale locale(DataContext root) {
        return (Locale)DataContext.Variable.LOCALE.get(root);
    }

    public static int customDateAdd(DataContext root, String timeFrameName, int interval, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.addDate(date, interval, timeFrame);
    }

    public static long customTimestampAdd(DataContext root, String timeFrameName, long interval, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.addTimestamp(timestamp, interval, timeFrame);
    }

    public static int customDateDiff(DataContext root, String timeFrameName, int date, int date2) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.diffDate(date, date2, timeFrame);
    }

    public static long customTimestampDiff(DataContext root, String timeFrameName, long timestamp, long timestamp2) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.diffTimestamp(timestamp, timestamp2, timeFrame);
    }

    public static int customDateFloor(DataContext root, String timeFrameName, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.floorDate(date, timeFrame);
    }

    public static int customDateCeil(DataContext root, String timeFrameName, int date) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.ceilDate(date, timeFrame);
    }

    public static long customTimestampFloor(DataContext root, String timeFrameName, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.floorTimestamp(timestamp, timeFrame);
    }

    public static long customTimestampCeil(DataContext root, String timeFrameName, long timestamp) {
        TimeFrameSet timeFrameSet = (TimeFrameSet)Objects.requireNonNull(DataContext.Variable.TIME_FRAME_SET.get(root));
        TimeFrame timeFrame = timeFrameSet.get(timeFrameName);
        return timeFrameSet.ceilTimestamp(timestamp, timeFrame);
    }

    public static String translate3(String s2, String search, String replacement) {
        return StringUtils.replaceChars((String)s2, (String)search, (String)replacement);
    }

    public static String replace(String s2, String search, String replacement) {
        return s2.replace(search, replacement);
    }

    public static @Nullable Object arrayItem(List list, int item, int offset, boolean safe) {
        if (item < offset || item > list.size() + 1 - offset) {
            if (safe) {
                return null;
            }
            throw Static.RESOURCE.arrayIndexOutOfBounds(item).ex();
        }
        return list.get(item - offset);
    }

    public static @Nullable Object mapItem(Map map, Object item) {
        return map.get(item);
    }

    public static @Nullable Object item(Object object, Object index) {
        if (object instanceof Map) {
            return SqlFunctions.mapItem((Map)object, index);
        }
        if (object instanceof List && index instanceof Number) {
            return SqlFunctions.arrayItem((List)object, ((Number)index).intValue(), 1, true);
        }
        if (index instanceof Number) {
            return SqlFunctions.structAccess(object, ((Number)index).intValue() - 1, null);
        }
        if (index instanceof String) {
            return SqlFunctions.structAccess(object, -1, index.toString());
        }
        return null;
    }

    public static @Nullable Object arrayItemOptional(@Nullable List list, int item, int offset, boolean safe) {
        if (list == null) {
            return null;
        }
        return SqlFunctions.arrayItem(list, item, offset, safe);
    }

    public static @Nullable Object mapItemOptional(@Nullable Map map, Object item) {
        if (map == null) {
            return null;
        }
        return SqlFunctions.mapItem(map, item);
    }

    public static @Nullable Object itemOptional(@Nullable Object object, Object index) {
        if (object == null) {
            return null;
        }
        return SqlFunctions.item(object, index);
    }

    public static boolean isTrue(@Nullable Boolean b) {
        return b != null && b != false;
    }

    public static boolean isFalse(@Nullable Boolean b) {
        return b != null && b == false;
    }

    public static boolean isNotTrue(@Nullable Boolean b) {
        return b == null || b == false;
    }

    public static boolean isNotFalse(@Nullable Boolean b) {
        return b == null || b != false;
    }

    public static @PolyNull Boolean not(@PolyNull Boolean b) {
        return b == null ? (Boolean)Nullness.castNonNull(null) : Boolean.valueOf(b == false);
    }

    public static @PolyNull List arrayToList(@PolyNull Array a) {
        if (a == null) {
            return Nullness.castNonNull(null);
        }
        try {
            return Primitive.asList(a.getArray());
        }
        catch (SQLException e) {
            throw Util.toUnchecked(e);
        }
    }

    @NonDeterministic
    public static long sequenceCurrentValue(String key) {
        return SqlFunctions.getAtomicLong(key).get();
    }

    @NonDeterministic
    public static long sequenceNextValue(String key) {
        return SqlFunctions.getAtomicLong(key).incrementAndGet();
    }

    private static AtomicLong getAtomicLong(String key) {
        Map<String, AtomicLong> map = Objects.requireNonNull(THREAD_SEQUENCES.get(), "THREAD_SEQUENCES.get()");
        AtomicLong atomic = map.get(key);
        if (atomic == null) {
            atomic = new AtomicLong();
            map.put(key, atomic);
        }
        return atomic;
    }

    public static @Nullable Boolean arraysOverlap(List list1, List list2) {
        if (list1.size() > list2.size()) {
            return SqlFunctions.arraysOverlap(list2, list1);
        }
        List smaller = list1;
        List bigger = list2;
        boolean hasNull = false;
        if (smaller.size() > 0 && bigger.size() > 0) {
            HashSet smallestSet = new HashSet(smaller);
            hasNull = smallestSet.remove(null);
            for (Object element : bigger) {
                if (element == null) {
                    hasNull = true;
                    continue;
                }
                if (!smallestSet.contains(element)) continue;
                return true;
            }
        }
        if (hasNull) {
            return null;
        }
        return false;
    }

    public static List arraysZip(List ... lists) {
        int biggestCardinality = lists.length == 0 ? 0 : Arrays.stream(lists).mapToInt(List::size).max().getAsInt();
        ArrayList result = new ArrayList(biggestCardinality);
        for (int i = 0; i < biggestCardinality; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (List list : lists) {
                Object value = i < list.size() && list.get(i) != null ? (Object)list.get(i) : null;
                row.add(value);
            }
            result.add(row);
        }
        return result;
    }

    public static List compact(List list) {
        ArrayList result = new ArrayList();
        for (Object element : list) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static List arrayAppend(List list, Object element) {
        ArrayList<Object> result = new ArrayList<Object>(list.size() + 1);
        result.addAll(list);
        result.add(element);
        return result;
    }

    public static List distinct(List list) {
        LinkedHashSet result = new LinkedHashSet(list);
        return new ArrayList(result);
    }

    public static <T> @Nullable T arrayMax(List<? extends T> list) {
        Object max = null;
        for (int i = 0; i < list.size(); ++i) {
            T item = list.get(i);
            if (item == null || max != null && ((Comparable)item).compareTo(max) <= 0) continue;
            max = item;
        }
        return max;
    }

    public static <T> @Nullable T arrayMin(List<? extends T> list) {
        Object min2 = null;
        for (int i = 0; i < list.size(); ++i) {
            T item = list.get(i);
            if (item == null || min2 != null && ((Comparable)item).compareTo(min2) >= 0) continue;
            min2 = item;
        }
        return min2;
    }

    public static List arrayPrepend(List list, Object element) {
        ArrayList<Object> result = new ArrayList<Object>(list.size() + 1);
        result.add(element);
        result.addAll(list);
        return result;
    }

    public static Long arrayPosition(List list, Object element) {
        int index = list.indexOf(element);
        if (index != -1) {
            return (long)index + 1L;
        }
        return 0L;
    }

    public static List arrayRemove(List list, Object element) {
        ArrayList result = new ArrayList();
        for (Object obj : list) {
            if (obj != null && obj.equals(element)) continue;
            result.add(obj);
        }
        return result;
    }

    public static @Nullable List<Object> repeat(Object element, Object count) {
        if (count == null) {
            return null;
        }
        int numberOfElement = (Integer)count;
        if (numberOfElement < 0) {
            numberOfElement = 0;
        }
        return Collections.nCopies(numberOfElement, element);
    }

    public static List arrayExcept(List list1, List list2) {
        LinkedHashSet result = new LinkedHashSet(list1);
        result.removeAll(list2);
        return new ArrayList(result);
    }

    public static List arrayIntersect(List list1, List list2) {
        LinkedHashSet result = new LinkedHashSet(list1);
        result.retainAll(list2);
        return new ArrayList(result);
    }

    public static List arrayUnion(List list1, List list2) {
        LinkedHashSet result = new LinkedHashSet();
        result.addAll(list1);
        result.addAll(list2);
        return new ArrayList(result);
    }

    public static List sortArray(List list, boolean ascending) {
        Comparator comparator = ascending ? Comparator.nullsFirst(Comparator.naturalOrder()) : Comparator.nullsLast(Comparator.reverseOrder());
        list.sort(comparator);
        return list;
    }

    public static Map mapConcat(Map ... maps) {
        LinkedHashMap result = new LinkedHashMap();
        Arrays.stream(maps).forEach(result::putAll);
        return result;
    }

    public static List mapEntries(Map<Object, Object> map) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            result.add(Arrays.asList(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static List mapKeys(Map map) {
        return new ArrayList(map.keySet());
    }

    public static List mapValues(Map map) {
        return new ArrayList(map.values());
    }

    public static Map mapFromArrays(List keysArray, List valuesArray) {
        if (keysArray.size() != valuesArray.size()) {
            throw Static.RESOURCE.illegalArgumentsInMapFromArraysFunc(keysArray.size(), valuesArray.size()).ex();
        }
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < keysArray.size(); ++i) {
            map.put(keysArray.get(i), valuesArray.get(i));
        }
        return map;
    }

    public static @Nullable Map mapFromEntries(List entries) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (Object entry : entries) {
            if (entry == null) {
                return null;
            }
            map.put(SqlFunctions.structAccess(entry, 0, null), SqlFunctions.structAccess(entry, 1, null));
        }
        return map;
    }

    public static Map strToMap(String string, String stringDelimiter, String keyValueDelimiter) {
        String[] keyValues;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String s2 : keyValues = string.split(stringDelimiter, -1)) {
            String[] keyValueArray = s2.split(keyValueDelimiter, 2);
            String key = keyValueArray[0];
            String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            map.put(key, value);
        }
        return map;
    }

    public static List slice(List list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object e : list) {
            result.add(SqlFunctions.structAccess(e, 0, null));
        }
        return result;
    }

    public static @Nullable Object element(List list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw Static.RESOURCE.moreThanOneValueInList(list.toString()).ex();
    }

    public static boolean memberOf(@Nullable Object object, Collection collection) {
        return collection.contains(object);
    }

    public static <E> Collection<E> multisetIntersectDistinct(Collection<E> c1, Collection<E> c2) {
        HashSet<E> result = new HashSet<E>(c1);
        result.retainAll(c2);
        return new ArrayList<E>(result);
    }

    public static <E> Collection<E> multisetIntersectAll(Collection<E> c1, Collection<E> c2) {
        ArrayList<E> result = new ArrayList<E>(c1.size());
        ArrayList<E> c2Copy = new ArrayList<E>(c2);
        for (E e : c1) {
            if (!c2Copy.remove(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E> Collection<E> multisetExceptAll(Collection<E> c1, Collection<E> c2) {
        LinkedList<E> result = new LinkedList<E>(c1);
        for (E e : c2) {
            result.remove(e);
        }
        return result;
    }

    public static <E> Collection<E> multisetExceptDistinct(Collection<E> c1, Collection<E> c2) {
        HashSet<E> result = new HashSet<E>(c1);
        result.removeAll(c2);
        return new ArrayList<E>(result);
    }

    public static boolean isASet(Collection collection) {
        if (collection instanceof Set) {
            return true;
        }
        HashSet set = new HashSet(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        for (Object e : collection) {
            if (set.add(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean submultisetOf(Collection possibleSubMultiset, Collection multiset) {
        if (possibleSubMultiset.size() > multiset.size()) {
            return false;
        }
        LinkedList multisetLocal = new LinkedList(multiset);
        for (Object e : possibleSubMultiset) {
            if (multisetLocal.remove(e)) continue;
            return false;
        }
        return true;
    }

    public static Collection multisetUnionDistinct(Collection collection1, Collection collection2) {
        HashSet resultCollection = new HashSet(Math.max((int)((float)(collection1.size() + collection2.size()) / 0.75f) + 1, 16));
        resultCollection.addAll(collection1);
        resultCollection.addAll(collection2);
        return new ArrayList(resultCollection);
    }

    public static Collection multisetUnionAll(Collection collection1, Collection collection2) {
        ArrayList resultCollection = new ArrayList(collection1.size() + collection2.size());
        resultCollection.addAll(collection1);
        resultCollection.addAll(collection2);
        return resultCollection;
    }

    public static List reverse(List list) {
        Collections.reverse(list);
        return list;
    }

    public static String arrayToString(List list, String delimiter) {
        return SqlFunctions.arrayToString(list, delimiter, null);
    }

    public static String arrayToString(List list, String delimiter, @Nullable String nullText) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object item : list) {
            String str;
            if (item == null) {
                if (nullText == null) continue;
                str = nullText;
            } else if (item instanceof String) {
                str = (String)item;
            } else if (item instanceof ByteString) {
                str = item.toString();
            } else {
                throw new IllegalStateException("arrayToString supports only String or ByteString, but got " + item.getClass().getName());
            }
            if (!isFirst) {
                sb.append(delimiter);
            }
            sb.append(str);
            isFirst = false;
        }
        return sb.toString();
    }

    public static Function1<List<Object>, Enumerable<Object>> flatList() {
        return inputList -> Linq4j.asEnumerable(inputList).select(v -> SqlFunctions.structAccess(v, 0, null));
    }

    public static Function1<Object, Enumerable<FlatLists.ComparableList<Comparable>>> flatProduct(int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        if (fieldCounts.length == 1) {
            if (!withOrdinality && inputTypes[0] == FlatProductInputType.SCALAR) {
                return LIST_AS_ENUMERABLE;
            }
            return row -> SqlFunctions.p2(new Object[]{row}, fieldCounts, withOrdinality, inputTypes);
        }
        return lists -> SqlFunctions.p2((Object[])lists, fieldCounts, withOrdinality, inputTypes);
    }

    private static Enumerable<FlatLists.ComparableList<Comparable>> p2(Object[] lists, int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        ArrayList<Enumerator<List<Enumerator<List<Object>>>>> enumerators = new ArrayList<Enumerator<List<Enumerator<List<Object>>>>>();
        int totalFieldCount = 0;
        for (int i = 0; i < lists.length; ++i) {
            int fieldCount = fieldCounts[i];
            FlatProductInputType inputType = inputTypes[i];
            Object inputObject = lists[i];
            switch (inputType) {
                case SCALAR: {
                    List list = (List)inputObject;
                    enumerators.add(Linq4j.transform(Linq4j.enumerator(list), FlatLists::of));
                    break;
                }
                case LIST: {
                    List listList = (List)inputObject;
                    enumerators.add(Linq4j.enumerator(listList));
                    break;
                }
                case MAP: {
                    Map map = (Map)inputObject;
                    Enumerator enumerator = Linq4j.enumerator(map.entrySet());
                    Enumerator<List> transformed = Linq4j.transform(enumerator, e -> FlatLists.of(e.getKey(), e.getValue()));
                    enumerators.add(transformed);
                    break;
                }
            }
            if (fieldCount < 0) {
                ++totalFieldCount;
                continue;
            }
            totalFieldCount += fieldCount;
        }
        if (withOrdinality) {
            ++totalFieldCount;
        }
        return SqlFunctions.product(enumerators, totalFieldCount, withOrdinality);
    }

    public static Object[] array(Object ... args) {
        return args;
    }

    public static <E> @Nullable Boolean nullableExists(List<? extends E> list, Function1<E, Boolean> predicate) {
        boolean nullExists = false;
        for (E e : list) {
            Boolean res = predicate.apply(e);
            if (res == null) {
                nullExists = true;
                continue;
            }
            if (!res.booleanValue()) continue;
            return true;
        }
        return nullExists ? null : Boolean.valueOf(false);
    }

    public static <E> @Nullable Boolean nullableAll(List<? extends E> list, Function1<E, Boolean> predicate) {
        boolean nullExists = false;
        for (E e : list) {
            Boolean res = predicate.apply(e);
            if (res == null) {
                nullExists = true;
                continue;
            }
            if (res.booleanValue()) continue;
            return false;
        }
        return nullExists ? null : Boolean.valueOf(true);
    }

    public static <E extends Comparable> Enumerable<FlatLists.ComparableList<E>> product(final List<Enumerator<List<E>>> enumerators, final int fieldCount, final boolean withOrdinality) {
        return new AbstractEnumerable<FlatLists.ComparableList<E>>(){

            @Override
            public Enumerator<FlatLists.ComparableList<E>> enumerator() {
                return new ProductComparableListEnumerator(enumerators, fieldCount, withOrdinality);
            }
        };
    }

    public static @Nullable Object structAccess(@Nullable Object structObject, int index, @Nullable String fieldName) {
        if (structObject == null) {
            return null;
        }
        if (structObject instanceof Object[]) {
            return ((Object[])structObject)[index];
        }
        if (structObject instanceof List) {
            return ((List)structObject).get(index);
        }
        if (structObject instanceof Row) {
            return ((Row)structObject).getObject(index);
        }
        Class<?> beanClass = structObject.getClass();
        try {
            if (fieldName == null) {
                throw new IllegalStateException("Field name cannot be null for struct field access");
            }
            Field structField = beanClass.getDeclaredField(fieldName);
            return structField.get(structObject);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw Static.RESOURCE.failedToAccessField(fieldName, index, beanClass.getName()).ex(ex);
        }
    }

    public static enum FlatProductInputType {
        SCALAR,
        LIST,
        MAP;

    }

    private static class ProductComparableListEnumerator<E extends Comparable>
    extends CartesianProductEnumerator<List<E>, FlatLists.ComparableList<E>> {
        final Object[] flatElements;
        final List<Object> list;
        private final boolean withOrdinality;
        private int ordinality;

        ProductComparableListEnumerator(List<Enumerator<List<E>>> enumerators, int fieldCount, boolean withOrdinality) {
            super(enumerators);
            this.withOrdinality = withOrdinality;
            this.flatElements = new Object[fieldCount];
            this.list = Arrays.asList(this.flatElements);
        }

        @Override
        public boolean moveNext() {
            boolean hasNext = super.moveNext();
            if (hasNext && this.withOrdinality) {
                ++this.ordinality;
            }
            return hasNext;
        }

        @Override
        public FlatLists.ComparableList<E> current() {
            int i = 0;
            for (Object element : this.elements) {
                Object[] a;
                if (element.getClass().isArray()) {
                    a = (Object[])element;
                } else {
                    List list2 = (List)element;
                    a = list2.toArray();
                }
                System.arraycopy(a, 0, this.flatElements, i, a.length);
                i += a.length;
            }
            if (this.withOrdinality) {
                this.flatElements[i] = this.ordinality;
            }
            return (FlatLists.ComparableList)FlatLists.of(this.list);
        }

        @Override
        public void reset() {
            super.reset();
            if (this.withOrdinality) {
                this.ordinality = 0;
            }
        }
    }
}

