/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;
import java.util.TimeZone;

public class SqlDataTypeSpec
extends SqlNode {
    private final SqlTypeNameSpec typeNameSpec;
    private final @Nullable TimeZone timeZone;
    private final @Nullable Boolean nullable;

    public SqlDataTypeSpec(SqlTypeNameSpec typeNameSpec, SqlParserPos pos) {
        this(typeNameSpec, null, null, pos);
    }

    public SqlDataTypeSpec(SqlTypeNameSpec typeNameSpec, @Nullable TimeZone timeZone, SqlParserPos pos) {
        this(typeNameSpec, timeZone, null, pos);
    }

    public SqlDataTypeSpec(SqlTypeNameSpec typeNameSpec, @Nullable TimeZone timeZone, @Nullable Boolean nullable, SqlParserPos pos) {
        super(pos);
        this.typeNameSpec = typeNameSpec;
        this.timeZone = timeZone;
        this.nullable = nullable;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlDataTypeSpec(this.typeNameSpec, this.timeZone, pos);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return SqlMonotonicity.CONSTANT;
    }

    public @Nullable SqlIdentifier getCollectionsTypeName() {
        if (this.typeNameSpec instanceof SqlCollectionTypeNameSpec) {
            return this.typeNameSpec.getTypeName();
        }
        return null;
    }

    public SqlIdentifier getTypeName() {
        return this.typeNameSpec.getTypeName();
    }

    public SqlTypeNameSpec getTypeNameSpec() {
        return this.typeNameSpec;
    }

    public @Nullable TimeZone getTimeZone() {
        return this.timeZone;
    }

    public @Nullable Boolean getNullable() {
        return this.nullable;
    }

    public SqlDataTypeSpec withNullable(Boolean nullable) {
        return this.withNullable(nullable, SqlParserPos.ZERO);
    }

    public SqlDataTypeSpec withNullable(Boolean nullable, SqlParserPos pos) {
        SqlParserPos newPos;
        SqlParserPos sqlParserPos = newPos = pos == SqlParserPos.ZERO ? this.pos : this.pos.plus(pos);
        if (Objects.equals(nullable, this.nullable) && newPos.equals(this.pos)) {
            return this;
        }
        return new SqlDataTypeSpec(this.typeNameSpec, this.timeZone, nullable, newPos);
    }

    public SqlDataTypeSpec getComponentTypeSpec() {
        assert (this.typeNameSpec instanceof SqlCollectionTypeNameSpec);
        SqlTypeNameSpec elementTypeName = ((SqlCollectionTypeNameSpec)this.typeNameSpec).getElementTypeName();
        return new SqlDataTypeSpec(elementTypeName, this.timeZone, this.getParserPosition());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.typeNameSpec.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateDataType(this);
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(@Nullable SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlDataTypeSpec)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlDataTypeSpec that = (SqlDataTypeSpec)node;
        if (!Objects.equals(this.timeZone, that.timeZone)) {
            return litmus.fail("{} != {}", this, node);
        }
        if (!this.typeNameSpec.equalsDeep(that.typeNameSpec, litmus)) {
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public RelDataType deriveType(SqlValidator validator) {
        return this.deriveType(validator, false);
    }

    public RelDataType deriveType(SqlValidator validator, boolean nullable) {
        RelDataType type = this.typeNameSpec.deriveType(validator);
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        type = this.fixUpNullability(typeFactory, type, nullable);
        return type;
    }

    private RelDataType fixUpNullability(RelDataTypeFactory typeFactory, RelDataType type, boolean nullable) {
        if (this.nullable != null) {
            nullable = this.nullable;
        }
        return typeFactory.createTypeWithNullability(type, nullable);
    }
}

