/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeTransforms;
import java.util.Locale;

public class SqlJsonRemoveFunction
extends SqlFunction {
    public SqlJsonRemoveFunction() {
        super("JSON_REMOVE", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), null, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int operandCount = callBinding.getOperandCount();
        assert (operandCount >= 2);
        if (!OperandTypes.ANY.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure)) {
            return false;
        }
        SqlTypeFamily[] families = new SqlTypeFamily[operandCount];
        families[0] = SqlTypeFamily.ANY;
        for (int i = 1; i < operandCount; ++i) {
            families[i] = SqlTypeFamily.CHARACTER;
        }
        return OperandTypes.family(families).checkOperandTypes(callBinding, throwOnFailure);
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return String.format(Locale.ROOT, "'%s(<%s>, <%s>, <%s>...)'", this.getName(), SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER);
    }
}

