/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.type;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExplicitOperandTypeChecker
implements SqlOperandTypeChecker {
    private final RelDataType type;

    public ExplicitOperandTypeChecker(RelDataType type) {
        this.type = Objects.requireNonNull(type, "type");
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
        List<RelDataTypeField> fieldList = this.type.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            RelDataTypeField field = fieldList.get(i);
            SqlTypeName sqlTypeName = field.getType().getSqlTypeName();
            if (sqlTypeName == SqlTypeName.ROW) {
                if (!field.getType().equals(callBinding.getOperandType(i))) continue;
                families.add(SqlTypeFamily.ANY);
                continue;
            }
            families.add(Objects.requireNonNull(sqlTypeName.getFamily(), () -> "keyType.getSqlTypeName().getFamily() null, type is " + (Object)((Object)sqlTypeName)));
        }
        return OperandTypes.family(families).checkOperandTypes(callBinding, throwOnFailure);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(this.type.getFieldCount());
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<TYPE> " + opName + " <TYPE>";
    }
}

