/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geomgraph;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geomgraph.EdgeEnd;
import com.hazelcast.shaded.org.locationtech.jts.geomgraph.Node;
import com.hazelcast.shaded.org.locationtech.jts.geomgraph.NodeFactory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class NodeMap {
    Map nodeMap = new TreeMap();
    NodeFactory nodeFact;

    public NodeMap(NodeFactory nodeFact) {
        this.nodeFact = nodeFact;
    }

    public Node addNode(Coordinate coord) {
        Node node = (Node)this.nodeMap.get(coord);
        if (node == null) {
            node = this.nodeFact.createNode(coord);
            this.nodeMap.put(coord, node);
        }
        return node;
    }

    public Node addNode(Node n) {
        Node node = (Node)this.nodeMap.get(n.getCoordinate());
        if (node == null) {
            this.nodeMap.put(n.getCoordinate(), n);
            return n;
        }
        node.mergeLabel(n);
        return node;
    }

    public void add(EdgeEnd e) {
        Coordinate p = e.getCoordinate();
        Node n = this.addNode(p);
        n.add(e);
    }

    public Node find(Coordinate coord) {
        return (Node)this.nodeMap.get(coord);
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public Collection values() {
        return this.nodeMap.values();
    }

    public Collection getBoundaryNodes(int geomIndex) {
        ArrayList<Node> bdyNodes = new ArrayList<Node>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getLabel().getLocation(geomIndex) != 1) continue;
            bdyNodes.add(node);
        }
        return bdyNodes;
    }

    public void print(PrintStream out) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.print(out);
        }
    }
}

