/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.noding;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.LineIntersector;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.noding.NodedSegmentString;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentIntersector;
import com.hazelcast.shaded.org.locationtech.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.List;

public class InteriorIntersectionFinderAdder
implements SegmentIntersector {
    private LineIntersector li;
    private final List interiorIntersections;

    public InteriorIntersectionFinderAdder(LineIntersector li) {
        this.li = li;
        this.interiorIntersections = new ArrayList();
    }

    public List getInteriorIntersections() {
        return this.interiorIntersections;
    }

    @Override
    public void processIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection() && this.li.isInteriorIntersection()) {
            for (int intIndex = 0; intIndex < this.li.getIntersectionNum(); ++intIndex) {
                this.interiorIntersections.add(this.li.getIntersection(intIndex));
            }
            ((NodedSegmentString)e0).addIntersections(this.li, segIndex0, 0);
            ((NodedSegmentString)e1).addIntersections(this.li, segIndex1, 1);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

