/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.BoundaryNodeRule;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateArrays;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiLineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.MultiPoint;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.operation.Counter;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class BoundaryOp {
    private Geometry geom;
    private GeometryFactory geomFact;
    private BoundaryNodeRule bnRule;
    private Map endpointMap;

    public static Geometry getBoundary(Geometry g2) {
        BoundaryOp bop = new BoundaryOp(g2);
        return bop.getBoundary();
    }

    public static Geometry getBoundary(Geometry g2, BoundaryNodeRule bnRule) {
        BoundaryOp bop = new BoundaryOp(g2, bnRule);
        return bop.getBoundary();
    }

    public static boolean hasBoundary(Geometry geom, BoundaryNodeRule boundaryNodeRule) {
        if (geom.isEmpty()) {
            return false;
        }
        switch (geom.getDimension()) {
            case 0: {
                return false;
            }
            case 1: {
                Geometry boundary = BoundaryOp.getBoundary(geom, boundaryNodeRule);
                return !boundary.isEmpty();
            }
            case 2: {
                return true;
            }
        }
        return true;
    }

    public BoundaryOp(Geometry geom) {
        this(geom, BoundaryNodeRule.MOD2_BOUNDARY_RULE);
    }

    public BoundaryOp(Geometry geom, BoundaryNodeRule bnRule) {
        this.geom = geom;
        this.geomFact = geom.getFactory();
        this.bnRule = bnRule;
    }

    public Geometry getBoundary() {
        if (this.geom instanceof LineString) {
            return this.boundaryLineString((LineString)this.geom);
        }
        if (this.geom instanceof MultiLineString) {
            return this.boundaryMultiLineString((MultiLineString)this.geom);
        }
        return this.geom.getBoundary();
    }

    private MultiPoint getEmptyMultiPoint() {
        return this.geomFact.createMultiPoint();
    }

    private Geometry boundaryMultiLineString(MultiLineString mLine) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        Coordinate[] bdyPts = this.computeBoundaryCoordinates(mLine);
        if (bdyPts.length == 1) {
            return this.geomFact.createPoint(bdyPts[0]);
        }
        return this.geomFact.createMultiPointFromCoords(bdyPts);
    }

    private Coordinate[] computeBoundaryCoordinates(MultiLineString mLine) {
        ArrayList bdyPts = new ArrayList();
        this.endpointMap = new TreeMap();
        for (int i = 0; i < mLine.getNumGeometries(); ++i) {
            LineString line = (LineString)mLine.getGeometryN(i);
            if (line.getNumPoints() == 0) continue;
            this.addEndpoint(line.getCoordinateN(0));
            this.addEndpoint(line.getCoordinateN(line.getNumPoints() - 1));
        }
        for (Map.Entry entry : this.endpointMap.entrySet()) {
            Counter counter = (Counter)entry.getValue();
            int valence = counter.count;
            if (!this.bnRule.isInBoundary(valence)) continue;
            bdyPts.add(entry.getKey());
        }
        return CoordinateArrays.toCoordinateArray(bdyPts);
    }

    private void addEndpoint(Coordinate pt) {
        Counter counter = (Counter)this.endpointMap.get(pt);
        if (counter == null) {
            counter = new Counter();
            this.endpointMap.put(pt, counter);
        }
        ++counter.count;
    }

    private Geometry boundaryLineString(LineString line) {
        if (this.geom.isEmpty()) {
            return this.getEmptyMultiPoint();
        }
        if (line.isClosed()) {
            boolean closedEndpointOnBoundary = this.bnRule.isInBoundary(2);
            if (closedEndpointOnBoundary) {
                return line.getStartPoint();
            }
            return this.geomFact.createMultiPoint();
        }
        return this.geomFact.createMultiPoint(new Point[]{line.getStartPoint(), line.getEndPoint()});
    }
}

