/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.buffer;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.Distance;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.Orientation;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateList;

public class BufferInputLineSimplifier {
    private static final int INIT = 0;
    private static final int DELETE = 1;
    private static final int KEEP = 1;
    private Coordinate[] inputLine;
    private double distanceTol;
    private byte[] isDeleted;
    private int angleOrientation = 1;
    private static final int NUM_PTS_TO_CHECK = 10;

    public static Coordinate[] simplify(Coordinate[] inputLine, double distanceTol) {
        BufferInputLineSimplifier simp = new BufferInputLineSimplifier(inputLine);
        return simp.simplify(distanceTol);
    }

    public BufferInputLineSimplifier(Coordinate[] inputLine) {
        this.inputLine = inputLine;
    }

    public Coordinate[] simplify(double distanceTol) {
        this.distanceTol = Math.abs(distanceTol);
        if (distanceTol < 0.0) {
            this.angleOrientation = -1;
        }
        this.isDeleted = new byte[this.inputLine.length];
        boolean isChanged = false;
        while (isChanged = this.deleteShallowConcavities()) {
        }
        return this.collapseLine();
    }

    private boolean deleteShallowConcavities() {
        int index = 1;
        int midIndex = this.findNextNonDeletedIndex(index);
        int lastIndex = this.findNextNonDeletedIndex(midIndex);
        boolean isChanged = false;
        while (lastIndex < this.inputLine.length) {
            boolean isMiddleVertexDeleted = false;
            if (this.isDeletable(index, midIndex, lastIndex, this.distanceTol)) {
                this.isDeleted[midIndex] = 1;
                isMiddleVertexDeleted = true;
                isChanged = true;
            }
            index = isMiddleVertexDeleted ? lastIndex : midIndex;
            midIndex = this.findNextNonDeletedIndex(index);
            lastIndex = this.findNextNonDeletedIndex(midIndex);
        }
        return isChanged;
    }

    private int findNextNonDeletedIndex(int index) {
        int next;
        for (next = index + 1; next < this.inputLine.length && this.isDeleted[next] == 1; ++next) {
        }
        return next;
    }

    private Coordinate[] collapseLine() {
        CoordinateList coordList = new CoordinateList();
        for (int i = 0; i < this.inputLine.length; ++i) {
            if (this.isDeleted[i] == 1) continue;
            coordList.add(this.inputLine[i]);
        }
        return coordList.toCoordinateArray();
    }

    private boolean isDeletable(int i0, int i1, int i2, double distanceTol) {
        Coordinate p0 = this.inputLine[i0];
        Coordinate p1 = this.inputLine[i1];
        Coordinate p2 = this.inputLine[i2];
        if (!this.isConcave(p0, p1, p2)) {
            return false;
        }
        if (!this.isShallow(p0, p1, p2, distanceTol)) {
            return false;
        }
        return this.isShallowSampled(p0, p1, i0, i2, distanceTol);
    }

    private boolean isShallowConcavity(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        boolean isAngleToSimplify;
        int orientation = Orientation.index(p0, p1, p2);
        boolean bl = isAngleToSimplify = orientation == this.angleOrientation;
        if (!isAngleToSimplify) {
            return false;
        }
        double dist = Distance.pointToSegment(p1, p0, p2);
        return dist < distanceTol;
    }

    private boolean isShallowSampled(Coordinate p0, Coordinate p2, int i0, int i2, double distanceTol) {
        int inc = (i2 - i0) / 10;
        if (inc <= 0) {
            inc = 1;
        }
        for (int i = i0; i < i2; i += inc) {
            if (this.isShallow(p0, p2, this.inputLine[i], distanceTol)) continue;
            return false;
        }
        return true;
    }

    private boolean isShallow(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        double dist = Distance.pointToSegment(p1, p0, p2);
        return dist < distanceTol;
    }

    private boolean isConcave(Coordinate p0, Coordinate p1, Coordinate p2) {
        int orientation = Orientation.index(p0, p1, p2);
        boolean isConcave = orientation == this.angleOrientation;
        return isConcave;
    }
}

