/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayUtil;

public class FastOverlayFilter {
    private Geometry targetGeom;
    private boolean isTargetRectangle;

    public FastOverlayFilter(Geometry geom) {
        this.targetGeom = geom;
        this.isTargetRectangle = this.targetGeom.isRectangle();
    }

    public Geometry overlay(Geometry geom, int overlayOpCode) {
        if (overlayOpCode != 1) {
            return null;
        }
        return this.intersection(geom);
    }

    private Geometry intersection(Geometry geom) {
        Geometry resultForRect = this.intersectionRectangle(geom);
        if (resultForRect != null) {
            return resultForRect;
        }
        if (!this.isEnvelopeIntersects(this.targetGeom, geom)) {
            return this.createEmpty(geom);
        }
        return null;
    }

    private Geometry createEmpty(Geometry geom) {
        return OverlayUtil.createEmptyResult(geom.getDimension(), geom.getFactory());
    }

    private Geometry intersectionRectangle(Geometry geom) {
        if (!this.isTargetRectangle) {
            return null;
        }
        if (this.isEnvelopeCovers(this.targetGeom, geom)) {
            return geom.copy();
        }
        if (!this.isEnvelopeIntersects(this.targetGeom, geom)) {
            return this.createEmpty(geom);
        }
        return null;
    }

    private boolean isEnvelopeIntersects(Geometry a, Geometry b) {
        return a.getEnvelopeInternal().intersects(b.getEnvelopeInternal());
    }

    private boolean isEnvelopeCovers(Geometry a, Geometry b) {
        return a.getEnvelopeInternal().covers(b.getEnvelopeInternal());
    }
}

