/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.triangulate;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineSegment;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.ConstraintSplitPointFinder;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.Segment;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.SplitSegment;

public class NonEncroachingSplitPointFinder
implements ConstraintSplitPointFinder {
    @Override
    public Coordinate findSplitPoint(Segment seg, Coordinate encroachPt) {
        LineSegment lineSeg = seg.getLineSegment();
        double segLen = lineSeg.getLength();
        double midPtLen = segLen / 2.0;
        SplitSegment splitSeg = new SplitSegment(lineSeg);
        Coordinate projPt = NonEncroachingSplitPointFinder.projectedSplitPoint(seg, encroachPt);
        double nonEncroachDiam = projPt.distance(encroachPt) * 2.0 * 0.8;
        double maxSplitLen = nonEncroachDiam;
        if (maxSplitLen > midPtLen) {
            maxSplitLen = midPtLen;
        }
        splitSeg.setMinimumLength(maxSplitLen);
        splitSeg.splitAt(projPt);
        return splitSeg.getSplitPoint();
    }

    public static Coordinate projectedSplitPoint(Segment seg, Coordinate encroachPt) {
        LineSegment lineSeg = seg.getLineSegment();
        Coordinate projPt = lineSeg.project(encroachPt);
        return projPt;
    }
}

