/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class IndexCompositeFilter
implements IndexFilter,
IdentifiedDataSerializable {
    private List<IndexFilter> filters;

    public IndexCompositeFilter() {
    }

    public IndexCompositeFilter(IndexFilter ... filters) {
        assert (filters != null);
        this.filters = Arrays.asList(filters);
    }

    public IndexCompositeFilter(List<IndexFilter> filters) {
        this.filters = filters;
    }

    @Override
    public Comparable getComparable(ExpressionEvalContext evalContext) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean isCooperative() {
        for (IndexFilter f : this.filters) {
            if (f.isCooperative()) continue;
            return false;
        }
        return true;
    }

    public List<IndexFilter> getFilters() {
        return this.filters;
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 30;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeList(this.filters, (ObjectDataOutput)out);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.filters = SerializationUtil.readList((ObjectDataInput)in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexCompositeFilter that = (IndexCompositeFilter)o;
        return this.filters.equals(that.filters);
    }

    public int hashCode() {
        return this.filters.hashCode();
    }

    public String toString() {
        return "IndexCompositeFilter {filters=" + this.filters + "}";
    }
}

