/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan.index;

import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.util.Objects;

public class IndexRangeFilter
implements IndexFilter,
IdentifiedDataSerializable {
    private IndexFilterValue from;
    private boolean fromInclusive;
    private IndexFilterValue to;
    private boolean toInclusive;

    public IndexRangeFilter() {
    }

    public IndexRangeFilter(IndexFilterValue from, boolean fromInclusive, IndexFilterValue to, boolean toInclusive) {
        assert (from != null || !fromInclusive) : "Unspecified from end must not be inclusive";
        assert (to != null || !toInclusive) : "Unspecified to end must not be inclusive";
        this.from = from;
        this.fromInclusive = fromInclusive;
        this.to = to;
        this.toInclusive = toInclusive;
    }

    @Override
    public Comparable getComparable(ExpressionEvalContext evalContext) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean isCooperative() {
        return !(this.from != null && !this.from.isCooperative() || this.to != null && !this.to.isCooperative());
    }

    public IndexFilterValue getFrom() {
        return this.from;
    }

    public boolean isFromInclusive() {
        return this.fromInclusive;
    }

    public IndexFilterValue getTo() {
        return this.to;
    }

    public boolean isToInclusive() {
        return this.toInclusive;
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 29;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.from);
        out.writeBoolean(this.fromInclusive);
        out.writeObject((Object)this.to);
        out.writeBoolean(this.toInclusive);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.from = (IndexFilterValue)in.readObject();
        this.fromInclusive = in.readBoolean();
        this.to = (IndexFilterValue)in.readObject();
        this.toInclusive = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRangeFilter that = (IndexRangeFilter)o;
        return Objects.equals(this.from, that.from) && this.fromInclusive == that.fromInclusive && Objects.equals(this.to, that.to) && this.toInclusive == that.toInclusive;
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.fromInclusive ? 1 : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.toInclusive ? 1 : 0);
        return result;
    }

    public String toString() {
        return "IndexRangeFilter {from=" + this.from + ", fromInclusive=" + this.fromInclusive + ", to=" + this.to + ", toInclusive=" + this.toInclusive + "}";
    }
}

