/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.BiExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Objects;

public abstract class BiExpressionWithType<T>
extends BiExpression<T> {
    protected QueryDataType resultType;

    protected BiExpressionWithType() {
    }

    protected BiExpressionWithType(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType) {
        super(operand1, operand2);
        this.resultType = resultType;
    }

    @Override
    public QueryDataType getType() {
        return this.resultType;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject((Object)this.resultType);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.resultType = (QueryDataType)in.readObject();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.operand1, this.operand2, this.resultType);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        BiExpressionWithType that = (BiExpressionWithType)o;
        return Objects.equals(this.resultType, that.resultType);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{operand1=" + this.operand1 + ", operand2=" + this.operand2 + ", resType=" + this.resultType + "}";
    }
}

