/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.expression.predicate.ComparisonPredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotNullPredicate;
import com.hazelcast.sql.impl.expression.predicate.TernaryLogic;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class CaseExpression<T>
implements Expression<T> {
    private Expression<Boolean>[] whenExpressions;
    private Expression<?>[] thenExpressions;
    private Expression<?> elseExpression;

    public CaseExpression() {
    }

    private CaseExpression(Expression<Boolean>[] whenExpressions, Expression<?>[] thenExpressions, Expression<?> elseExpression) {
        this.whenExpressions = whenExpressions;
        this.thenExpressions = thenExpressions;
        this.elseExpression = elseExpression;
    }

    public static <T> CaseExpression<T> nullif(Expression<?> left, Expression<?> right) {
        return new CaseExpression<T>(new Expression[]{ComparisonPredicate.create(left, right, ComparisonMode.EQUALS)}, new Expression[]{ConstantExpression.create(null, left.getType())}, left);
    }

    public static <T> CaseExpression<T> coalesce(Expression<?> ... operands) {
        int branchesSize = operands.length - 1;
        Expression[] whenExpressions = new Expression[branchesSize];
        Expression[] thenExpressions = new Expression[branchesSize];
        for (int i = 0; i < branchesSize; ++i) {
            whenExpressions[i] = IsNotNullPredicate.create(operands[i]);
            thenExpressions[i] = operands[i];
        }
        return new CaseExpression<T>(whenExpressions, thenExpressions, operands[operands.length - 1]);
    }

    public static <T> CaseExpression<T> create(Expression<?>[] operands) {
        assert (operands.length % 2 == 1) : "CASE expression must have odd number of operands";
        int branchesSize = operands.length / 2;
        Expression[] whenExpressions = new Expression[branchesSize];
        Expression[] thenExpressions = new Expression[branchesSize];
        for (int i = 0; i < branchesSize; ++i) {
            whenExpressions[i] = operands[2 * i];
            thenExpressions[i] = operands[2 * i + 1];
        }
        return new CaseExpression<T>(whenExpressions, thenExpressions, operands[operands.length - 1]);
    }

    public int getClassId() {
        return 70;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.whenExpressions.length);
        for (int i = 0; i < this.whenExpressions.length; ++i) {
            out.writeObject(this.whenExpressions[i]);
            out.writeObject(this.thenExpressions[i]);
        }
        out.writeObject(this.elseExpression);
    }

    public void readData(ObjectDataInput in) throws IOException {
        int branchesSize = in.readInt();
        this.whenExpressions = new Expression[branchesSize];
        this.thenExpressions = new Expression[branchesSize];
        for (int i = 0; i < branchesSize; ++i) {
            this.whenExpressions[i] = (Expression)in.readObject();
            this.thenExpressions[i] = (Expression)in.readObject();
        }
        this.elseExpression = (Expression)in.readObject();
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        for (int i = 0; i < this.whenExpressions.length; ++i) {
            Expression<Boolean> condition = this.whenExpressions[i];
            Boolean conditionHolds = condition.eval(row, context);
            if (!TernaryLogic.isTrue(conditionHolds)) continue;
            return (T)this.thenExpressions[i].eval(row, context);
        }
        return (T)this.elseExpression.eval(row, context);
    }

    @Override
    public QueryDataType getType() {
        return this.elseExpression.getType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseExpression that = (CaseExpression)o;
        return Arrays.equals(this.whenExpressions, that.whenExpressions) && Arrays.equals(this.thenExpressions, that.thenExpressions) && Objects.equals(this.elseExpression, that.elseExpression);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.whenExpressions), Arrays.hashCode(this.thenExpressions), this.elseExpression);
    }

    public String toString() {
        return "CaseExpression{whenExpressions=" + Arrays.toString(this.whenExpressions) + ", thenExpressions=" + Arrays.toString(this.thenExpressions) + ", elseExpression=" + this.elseExpression + "}";
    }

    @Override
    public boolean isCooperative() {
        for (Expression<Boolean> expression : this.whenExpressions) {
            if (expression.isCooperative()) continue;
            return false;
        }
        for (Expression<Boolean> expression : this.thenExpressions) {
            if (expression.isCooperative()) continue;
            return false;
        }
        return this.elseExpression.isCooperative();
    }
}

