/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.VariExpression;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public abstract class VariExpressionWithType<T>
extends VariExpression<T> {
    protected QueryDataType resultType;

    protected VariExpressionWithType() {
    }

    protected VariExpressionWithType(Expression<?>[] operands, QueryDataType resultType) {
        this.operands = operands;
        this.resultType = resultType;
    }

    @Override
    public QueryDataType getType() {
        return this.resultType;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject((Object)this.resultType);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.resultType = (QueryDataType)in.readObject();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VariExpressionWithType that = (VariExpressionWithType)o;
        return this.resultType.equals(that.resultType);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{operand=" + Arrays.toString(this.operands) + ", resultType=" + this.resultType + "}";
    }
}

