/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpressionWithType;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.math.BigDecimal;

public final class UnaryMinusFunction<T>
extends UniExpressionWithType<T> {
    public UnaryMinusFunction() {
    }

    private UnaryMinusFunction(Expression<?> operand, QueryDataType resultType) {
        super(operand, resultType);
    }

    public static UnaryMinusFunction<?> create(Expression<?> operand, QueryDataType resultType) {
        return new UnaryMinusFunction(operand, resultType);
    }

    public int getClassId() {
        return 41;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object value = this.operand.eval(row, context);
        if (value == null) {
            return null;
        }
        QueryDataTypeFamily family = this.resultType.getTypeFamily();
        return (T)UnaryMinusFunction.evalNumeric((Number)value, family);
    }

    private static Object evalNumeric(Number number, QueryDataTypeFamily family) {
        switch (family) {
            case TINYINT: {
                return -number.byteValue();
            }
            case SMALLINT: {
                return -number.shortValue();
            }
            case INTEGER: {
                return -number.intValue();
            }
            case BIGINT: {
                try {
                    return Math.negateExact(number.longValue());
                }
                catch (ArithmeticException e) {
                    throw QueryException.error((int)2000, (String)"BIGINT overflow in unary '-' operator (consider adding explicit CAST to DECIMAL)");
                }
            }
            case DECIMAL: {
                return ((BigDecimal)number).negate(QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
            }
            case REAL: {
                return Float.valueOf(-number.floatValue());
            }
            case DOUBLE: {
                return -number.doubleValue();
            }
        }
        throw new IllegalArgumentException("unexpected result family: " + family);
    }
}

