/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.service;

import com.hazelcast.jet.impl.execution.CooperativeThread;
import com.hazelcast.map.IMap;
import com.hazelcast.security.permission.SqlPermission;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.TriExpression;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.SqlCatalogObject;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.security.Permission;

public class GetDdlFunction
extends TriExpression<String> {
    static final String RELATION_NAMESPACE = "relation";
    static final String DATACONNECTION_NAMESPACE = "dataconnection";

    public GetDdlFunction() {
    }

    public GetDdlFunction(Expression<?> op1, Expression<?> op2, Expression<?> op3) {
        super(op1, op2, op3);
    }

    @Override
    public String eval(Row row, ExpressionEvalContext context) {
        Object obj;
        CooperativeThread.checkNonCooperative();
        String namespace = StringFunctionUtils.asVarchar(this.operand1, row, context);
        if (namespace == null) {
            throw QueryException.error((String)"Namespace must not be null for GET_DDL");
        }
        String objectName = StringFunctionUtils.asVarchar(this.operand2, row, context);
        if (objectName == null) {
            throw QueryException.error((String)"Object_name must not be null for GET_DDL");
        }
        IMap sqlCatalog = context.getNodeEngine().getHazelcastInstance().getMap("__sql.catalog");
        if (!namespace.equals(RELATION_NAMESPACE) && !namespace.equals(DATACONNECTION_NAMESPACE)) {
            throw QueryException.error((String)("Namespace '" + namespace + "' is not supported. Only 'relation' and 'dataconnection' namespaces are supported."));
        }
        String keyName = objectName;
        if (namespace.equals(DATACONNECTION_NAMESPACE)) {
            keyName = QueryUtils.wrapDataConnectionKey(objectName);
        }
        if ((obj = sqlCatalog.get((Object)keyName)) == null) {
            throw QueryException.error((String)("Object '" + objectName + "' does not exist in namespace '" + namespace + "'"));
        }
        if (obj instanceof SqlCatalogObject) {
            SqlCatalogObject catalogObject = (SqlCatalogObject)obj;
            if (catalogObject instanceof Mapping) {
                context.checkPermission((Permission)new SqlPermission(catalogObject.name(), new String[]{"view-mapping"}));
            } else if (catalogObject instanceof DataConnectionCatalogEntry) {
                context.checkPermission((Permission)new SqlPermission(catalogObject.name(), new String[]{"view-dataconnection"}));
            }
        } else {
            throw new AssertionError((Object)"Object must not be present in information_schema");
        }
        String ddl = ((SqlCatalogObject)obj).unparse();
        return ddl;
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.VARCHAR;
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    public int getClassId() {
        return 90;
    }

    public static GetDdlFunction create(Expression<?> namespace, Expression<?> objectName, Expression<?> schema) {
        return new GetDdlFunction(namespace, objectName, schema);
    }
}

