/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.config.IndexType;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;

public class MapTableIndex {
    private final String name;
    private final IndexType type;
    private final int componentsCount;
    private final List<Integer> fieldOrdinals;
    private final List<QueryDataType> fieldConverterTypes;

    public MapTableIndex(String name, IndexType type, int componentsCount, List<Integer> fieldOrdinals, List<QueryDataType> fieldConverterTypes) {
        this.name = name;
        this.type = type;
        this.componentsCount = componentsCount;
        this.fieldOrdinals = fieldOrdinals;
        this.fieldConverterTypes = fieldConverterTypes;
    }

    public String getName() {
        return this.name;
    }

    public IndexType getType() {
        return this.type;
    }

    public int getComponentsCount() {
        return this.componentsCount;
    }

    public List<Integer> getFieldOrdinals() {
        return this.fieldOrdinals;
    }

    public List<QueryDataType> getFieldConverterTypes() {
        return this.fieldConverterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapTableIndex index = (MapTableIndex)o;
        return this.componentsCount == index.componentsCount && this.name.equals(index.name) && this.type == index.type && this.fieldOrdinals.equals(index.fieldOrdinals) && this.fieldConverterTypes.equals(index.fieldConverterTypes);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.componentsCount;
        result = 31 * result + this.fieldOrdinals.hashCode();
        result = 31 * result + this.fieldConverterTypes.hashCode();
        return result;
    }

    public String toString() {
        return "MapTableIndex {name='" + this.name + "', type=" + this.type + ", componentsCount=" + this.componentsCount + ", fieldOrdinals=" + this.fieldOrdinals + ", fieldConverterTypes=" + this.fieldConverterTypes + "}";
    }
}

