/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;

@SerializableByConvention
public final class IntegerConverter
extends Converter {
    public static final IntegerConverter INSTANCE = new IntegerConverter();

    private IntegerConverter() {
        super(3, QueryDataTypeFamily.INTEGER);
    }

    @Override
    public Class<?> getValueClass() {
        return Integer.class;
    }

    @Override
    public byte asTinyint(Object val) {
        int casted = this.cast(val);
        byte converted = (byte)casted;
        if (converted != casted) {
            throw this.numericOverflowError(QueryDataTypeFamily.TINYINT);
        }
        return converted;
    }

    @Override
    public short asSmallint(Object val) {
        int casted = this.cast(val);
        short converted = (short)casted;
        if (converted != casted) {
            throw this.numericOverflowError(QueryDataTypeFamily.SMALLINT);
        }
        return converted;
    }

    @Override
    public int asInt(Object val) {
        return this.cast(val);
    }

    @Override
    public long asBigint(Object val) {
        return this.cast(val);
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        return new BigDecimal(this.cast(val), QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
    }

    @Override
    public float asReal(Object val) {
        return this.cast(val);
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val);
    }

    @Override
    public String asVarchar(Object val) {
        return Integer.toString(this.cast(val));
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asInt(val);
    }

    private int cast(Object val) {
        return (Integer)val;
    }
}

