/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.session.SessionManager;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class HazelcastSessionChangeValve
extends ValveBase {
    private SessionManager sessionManager;

    public HazelcastSessionChangeValve(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.handleTomcatSessionChange(request);
        this.getNext().invoke(request, response);
    }

    private void handleTomcatSessionChange(Request request) throws IOException {
        String currentSessionId = request.getRequestedSessionId();
        if (currentSessionId == null) {
            return;
        }
        String jvmRoute = this.sessionManager.getJvmRoute();
        int index = currentSessionId.indexOf(".");
        String requestedJvmRoute = null;
        if (index > 0) {
            requestedJvmRoute = currentSessionId.substring(index + 1, currentSessionId.length());
        }
        if (requestedJvmRoute == null || requestedJvmRoute.equals(jvmRoute)) {
            return;
        }
        String newSessionId = this.sessionManager.updateJvmRouteForSession(currentSessionId, jvmRoute);
        request.changeSessionId(newSessionId);
    }
}

