/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.session.ClientServerLifecycleListener;
import com.hazelcast.session.HazelcastSession;
import com.hazelcast.session.HazelcastSessionChangeValve;
import com.hazelcast.session.HazelcastSessionCommitValve;
import com.hazelcast.session.P2PLifecycleListener;
import com.hazelcast.session.SessionManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.ManagerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class HazelcastSessionManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
SessionManager {
    private static final String NAME = "HazelcastSessionManager";
    private static final int DEFAULT_SESSION_TIMEOUT = 60;
    private static final int SECONDS_IN_MINUTE = 60;
    private final Log log = LogFactory.getLog(HazelcastSessionManager.class);
    private IMap<String, HazelcastSession> sessionMap;
    private boolean clientOnly;
    private boolean sticky = true;
    private String mapName;
    private boolean deferredWrite = true;
    private String hazelcastInstanceName;
    private HazelcastInstance instance;

    public void setSessionTimeout(int t) {
        this.getContext().setSessionTimeout(t);
    }

    public String getName() {
        return NAME;
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void startInternal() throws LifecycleException {
        super.startInternal();
        super.generateSessionId();
        this.configureValves();
        if (this.isClientOnly()) {
            try {
                ClientConfig clientConfig = ClientServerLifecycleListener.getConfig();
                clientConfig.setClassLoader(this.getContext().getLoader().getClassLoader());
                this.instance = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
            }
            catch (Exception e) {
                this.log.error((Object)"Hazelcast Client could not be created. ", (Throwable)e);
                throw new LifecycleException(e.getMessage());
            }
        } else {
            this.instance = this.getHazelcastInstanceName() != null ? Hazelcast.getHazelcastInstanceByName((String)this.getHazelcastInstanceName()) : Hazelcast.getOrCreateHazelcastInstance((Config)P2PLifecycleListener.getConfig());
        }
        if (this.getMapName() == null || "default".equals(this.getMapName())) {
            Context ctx = this.getContext();
            String contextPath = ctx.getServletContext().getContextPath();
            this.log.info((Object)("contextPath:" + contextPath));
            this.mapName = contextPath == null || contextPath.equals("/") || contextPath.equals("") ? "empty_session_replication" : contextPath.substring(1, contextPath.length()) + "_session_replication";
            this.sessionMap = this.instance.getMap(this.mapName);
        } else {
            this.sessionMap = this.instance.getMap(this.getMapName());
        }
        if (!this.isSticky()) {
            this.sessionMap.addEntryListener((EntryListener)new EntryListener<String, HazelcastSession>(){

                public void entryAdded(EntryEvent<String, HazelcastSession> event) {
                }

                public void entryRemoved(EntryEvent<String, HazelcastSession> entryEvent) {
                    if (entryEvent.getMember() == null || !entryEvent.getMember().localMember()) {
                        HazelcastSessionManager.this.sessions.remove(entryEvent.getKey());
                    }
                }

                public void entryUpdated(EntryEvent<String, HazelcastSession> event) {
                }

                public void entryEvicted(EntryEvent<String, HazelcastSession> entryEvent) {
                    this.entryRemoved(entryEvent);
                }

                public void mapEvicted(MapEvent event) {
                }

                public void mapCleared(MapEvent event) {
                }
            }, false);
        }
        this.log.info((Object)"HazelcastSessionManager started...");
        this.setState(LifecycleState.STARTING);
    }

    private void configureValves() {
        if (this.isSticky()) {
            HazelcastSessionChangeValve hazelcastSessionChangeValve = new HazelcastSessionChangeValve(this);
            hazelcastSessionChangeValve.setAsyncSupported(true);
            this.getContext().getPipeline().addValve((Valve)hazelcastSessionChangeValve);
        }
        if (this.isDeferredEnabled()) {
            HazelcastSessionCommitValve hazelcastSessionCommitValve = new HazelcastSessionCommitValve(this);
            hazelcastSessionCommitValve.setAsyncSupported(true);
            this.getContext().getPipeline().addValve((Valve)hazelcastSessionCommitValve);
        }
    }

    public void stopInternal() throws LifecycleException {
        this.log.info((Object)"stopping HazelcastSessionManager...");
        this.setState(LifecycleState.STOPPING);
        if (this.isClientOnly()) {
            this.instance.shutdown();
        }
        super.stopInternal();
        this.log.info((Object)"HazelcastSessionManager stopped...");
    }

    public int getRejectedSessions() {
        return 0;
    }

    public void setRejectedSessions(int i) {
    }

    public Session createSession(String sessionId) {
        this.checkMaxActiveSessions();
        HazelcastSession session = (HazelcastSession)this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.getContext().getSessionTimeout() * 60);
        String newSessionId = sessionId;
        if (newSessionId == null) {
            newSessionId = this.generateSessionId();
        }
        session.setId(newSessionId);
        session.tellNew();
        this.sessions.put(newSessionId, session);
        this.sessionMap.set((Object)newSessionId, (Object)session);
        return session;
    }

    public Session createEmptySession() {
        return new HazelcastSession(this);
    }

    public void add(Session session) {
        this.sessions.put(session.getId(), (HazelcastSession)session);
        this.sessionMap.set((Object)session.getId(), (Object)((HazelcastSession)session));
    }

    public Session findSession(String id) throws IOException {
        this.log.debug((Object)("Attempting to find sessionId:" + id));
        if (id == null) {
            return null;
        }
        if (!this.isSticky() || this.isSticky() && !this.sessions.containsKey(id)) {
            HazelcastSession hazelcastSession;
            if (this.isSticky()) {
                this.log.info((Object)("Sticky Session is currently enabled.Some failover occured so reading session from Hazelcast map:" + this.getMapName()));
            }
            if ((hazelcastSession = (HazelcastSession)((Object)this.sessionMap.get((Object)id))) == null) {
                this.log.info((Object)("No Session found for:" + id));
                return null;
            }
            this.log.info((Object)("Session found for:" + id));
            hazelcastSession.access();
            hazelcastSession.endAccess();
            hazelcastSession.setSessionManager(this);
            this.sessions.put(id, hazelcastSession);
            this.sessionMap.remove((Object)id);
            this.sessionMap.set((Object)id, (Object)hazelcastSession);
            return hazelcastSession;
        }
        return (Session)this.sessions.get(id);
    }

    @Override
    public void commit(Session session) {
        HazelcastSession hazelcastSession = (HazelcastSession)session;
        if (hazelcastSession.isDirty()) {
            hazelcastSession.setDirty(false);
            this.sessionMap.set((Object)session.getId(), (Object)hazelcastSession);
            this.log.info((Object)("Thread name:" + Thread.currentThread().getName() + " committed key:" + session.getId()));
        }
    }

    @Override
    public String updateJvmRouteForSession(String sessionId, String newJvmRoute) throws IOException {
        HazelcastSession session = (HazelcastSession)((Object)this.sessionMap.get((Object)sessionId));
        if (session == null) {
            session = (HazelcastSession)this.createSession(null);
            return session.getId();
        }
        if (session.getManager() == null) {
            session.setSessionManager(this);
        }
        int index = sessionId.indexOf(".");
        String baseSessionId = sessionId.substring(0, index);
        String newSessionId = baseSessionId + "." + newJvmRoute;
        session.setId(newSessionId);
        this.sessionMap.remove((Object)sessionId);
        this.sessionMap.set((Object)newSessionId, (Object)session);
        return newSessionId;
    }

    @Override
    public void remove(Session session) {
        this.remove(session.getId());
        this.log.info((Object)("Removed session: " + session.getId()));
    }

    public void remove(Session session, boolean update) {
        this.remove(session);
    }

    @Override
    public IMap<String, HazelcastSession> getDistributedMap() {
        return this.sessionMap;
    }

    @Override
    public boolean isDeferredEnabled() {
        return this.deferredWrite;
    }

    public boolean isClientOnly() {
        return this.clientOnly;
    }

    public void setClientOnly(boolean clientOnly) {
        this.clientOnly = clientOnly;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        if (!sticky && this.getJvmRoute() != null) {
            this.log.warn((Object)"setting JvmRoute with non-sticky sessions is not recommended and might cause unstable behaivour");
        }
        this.sticky = sticky;
    }

    private void remove(String id) {
        this.sessions.remove(id);
        this.sessionMap.remove((Object)id);
    }

    public void expireSession(String sessionId) {
        super.expireSession(sessionId);
        this.remove(sessionId);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("sessionTimeout")) {
            this.getContext().setSessionTimeout((Integer)evt.getNewValue() * 60);
        }
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public String getHazelcastInstanceName() {
        return this.hazelcastInstanceName;
    }

    public void setHazelcastInstanceName(String hazelcastInstanceName) {
        this.hazelcastInstanceName = hazelcastInstanceName;
    }

    private void checkMaxActiveSessions() {
        if (this.getMaxActiveSessions() >= 0 && this.sessionMap.size() >= this.getMaxActiveSessions()) {
            ++this.rejectedSessions;
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int maxActiveSessions) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = maxActiveSessions;
        this.support.firePropertyChange("maxActiveSessions", (Object)oldMaxActiveSessions, (Object)this.maxActiveSessions);
    }

    public void setDeferredWrite(boolean deferredWrite) {
        this.deferredWrite = deferredWrite;
    }
}

