/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.session.ClientServerLifecycleListener;
import com.hazelcast.session.P2PLifecycleListener;
import org.apache.catalina.LifecycleException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class HazelcastInstanceFactory {
    private static final Log LOGGER = LogFactory.getLog(HazelcastInstanceFactory.class);

    private HazelcastInstanceFactory() {
    }

    public static HazelcastInstance getHazelcastInstance(ClassLoader classLoader, boolean clientOnly, String instanceName) throws LifecycleException {
        HazelcastInstance instance;
        if (clientOnly) {
            try {
                ClientConfig clientConfig = ClientServerLifecycleListener.getConfig();
                clientConfig.setClassLoader(classLoader);
                instance = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Hazelcast Client could not be created.", (Throwable)e);
                throw new LifecycleException(e.getMessage());
            }
        } else if (instanceName != null) {
            instance = Hazelcast.getHazelcastInstanceByName((String)instanceName);
        } else {
            Config config = P2PLifecycleListener.getConfig();
            config.setClassLoader(classLoader);
            instance = Hazelcast.getOrCreateHazelcastInstance((Config)config);
        }
        return instance;
    }
}

