/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.session.SessionManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class HazelcastSession
extends StandardSession
implements DataSerializable {
    private static final Field ATTRIBUTES_FIELD;
    private static final Log LOG;
    protected boolean dirty;
    private transient SessionManager sessionManager;

    public HazelcastSession(SessionManager sessionManager) {
        super((Manager)sessionManager);
        this.sessionManager = sessionManager;
    }

    public HazelcastSession() {
        super(null);
    }

    public void setAttribute(String key, Object value) {
        super.setAttribute(key, value);
        this.updateSession();
    }

    public void removeAttribute(String name) {
        super.removeAttribute(name);
        this.updateSession();
    }

    public void setPrincipal(Principal principal) {
        super.setPrincipal(principal);
        this.updateSession();
    }

    public long getLastAccessedTime() {
        this.refreshAccessTimestamps();
        return super.getLastAccessedTime();
    }

    public boolean isValid() {
        this.refreshAccessTimestamps();
        return super.isValid();
    }

    private void refreshAccessTimestamps() {
        HazelcastSession distributedSession;
        if (this.sessionManager != null && !this.sessionManager.isSticky() && (distributedSession = (HazelcastSession)((Object)this.sessionManager.getDistributedMap().get((Object)this.getId()))) != null) {
            this.lastAccessedTime = distributedSession.lastAccessedTime;
            this.maxInactiveInterval = distributedSession.maxInactiveInterval;
            this.thisAccessedTime = distributedSession.thisAccessedTime;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        super.setMaxInactiveInterval(interval);
        this.updateSessionWithMaxIdleSeconds(interval);
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)"Session 'maxInactiveInterval' updated on Hazelcast cluster.");
        }
    }

    private void updateSessionWithMaxIdleSeconds(int interval) {
        this.sessionManager.getDistributedMap().set((Object)this.id, (Object)this, -1L, TimeUnit.MILLISECONDS, (long)interval, TimeUnit.SECONDS);
    }

    void setMaxInactiveIntervalLocal(int interval) {
        super.setMaxInactiveInterval(interval);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setSessionManager(SessionManager sessionManager) {
        super.setManager((Manager)sessionManager);
        this.sessionManager = sessionManager;
    }

    private void updateSession() {
        if (this.sessionManager.isDeferredEnabled()) {
            this.dirty = true;
        } else {
            this.sessionManager.getDistributedMap().set((Object)this.id, (Object)this);
        }
    }

    public void writeData(ObjectDataOutput objectDataOutput) throws IOException {
        objectDataOutput.writeLong(this.creationTime);
        objectDataOutput.writeLong(this.lastAccessedTime);
        objectDataOutput.writeInt(this.maxInactiveInterval);
        objectDataOutput.writeBoolean(this.isNew);
        objectDataOutput.writeBoolean(this.isValid);
        objectDataOutput.writeLong(this.thisAccessedTime);
        objectDataOutput.writeObject((Object)this.id);
        this.serializeMap(this.getAttributes(), objectDataOutput);
        this.serializeMap(this.notes, objectDataOutput);
    }

    private void serializeMap(Map map, ObjectDataOutput objectDataOutput) throws IOException {
        HashMap serializableEntries = new HashMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            serializableEntries.put(key, value);
        }
        objectDataOutput.writeInt(serializableEntries.size());
        for (Map.Entry entryObject : serializableEntries.entrySet()) {
            try {
                objectDataOutput.writeObject(entryObject.getKey());
                objectDataOutput.writeObject(entryObject.getValue());
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to serialize object in session", (Throwable)e);
            }
        }
    }

    public void readData(ObjectDataInput objectDataInput) throws IOException {
        this.creationTime = objectDataInput.readLong();
        this.lastAccessedTime = objectDataInput.readLong();
        this.maxInactiveInterval = objectDataInput.readInt();
        this.isNew = objectDataInput.readBoolean();
        this.isValid = objectDataInput.readBoolean();
        this.thisAccessedTime = objectDataInput.readLong();
        this.id = (String)objectDataInput.readObject();
        this.setAttributes(this.deserializeMap(objectDataInput, true));
        this.notes = this.deserializeMap(objectDataInput, false);
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    private Map deserializeMap(ObjectDataInput objectDataInput, boolean concurrent) throws IOException {
        int mapSize = objectDataInput.readInt();
        Map<Object, Object> map = concurrent ? new ConcurrentHashMap() : MapUtil.createHashMap((int)mapSize);
        for (int i = 0; i < mapSize; ++i) {
            try {
                map.put(objectDataInput.readObject(), objectDataInput.readObject());
                continue;
            }
            catch (Exception ex) {
                LOG.warn((Object)"Unable to deserialize object in session", (Throwable)ex);
            }
        }
        return map;
    }

    public Map getAttributes() {
        try {
            return (Map)ATTRIBUTES_FIELD.get((Object)this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setAttributes(Object attributes) {
        try {
            ATTRIBUTES_FIELD.set((Object)this, attributes);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static Field getAttributesField() {
        try {
            Field attributesField = StandardSession.class.getDeclaredField("attributes");
            attributesField.setAccessible(true);
            return attributesField;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LOG = LogFactory.getLog(HazelcastSession.class);
        ATTRIBUTES_FIELD = HazelcastSession.getAttributesField();
    }
}

