/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.session.HazelcastSession;
import java.util.Map;
import org.apache.catalina.Session;

public class LocalSessionsInvalidateListener
implements EntryEvictedListener<String, HazelcastSession>,
EntryRemovedListener<String, HazelcastSession> {
    private Map<String, Session> sessions;

    public LocalSessionsInvalidateListener(Map<String, Session> sessions) {
        this.sessions = sessions;
    }

    public void entryEvicted(EntryEvent<String, HazelcastSession> event) {
        this.invalidateSessions(event);
    }

    public void entryRemoved(EntryEvent<String, HazelcastSession> event) {
        this.invalidateSessions(event);
    }

    private void invalidateSessions(EntryEvent<String, HazelcastSession> entryEvent) {
        if (entryEvent.getMember() == null || !entryEvent.getMember().localMember()) {
            this.sessions.remove(entryEvent.getKey());
        }
    }
}

