/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.client.config.impl.ClientXmlConfigRootTagRecognizer;
import com.hazelcast.client.config.impl.ClientYamlConfigRootTagRecognizer;
import com.hazelcast.config.ConfigRecognizer;
import com.hazelcast.config.ConfigStream;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.ConfigLoader;
import java.net.URL;

class ClientServerConfigLoader {
    private ConfigRecognizer xmlConfigRecognizer = new ClientXmlConfigRootTagRecognizer();
    private ConfigRecognizer yamlConfigRecognizer = new ClientYamlConfigRootTagRecognizer();

    ClientServerConfigLoader() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConfig load(String path) throws Exception {
        URL url = ConfigLoader.locateConfig((String)path);
        if (url == null) {
            return null;
        }
        ConfigStream xmlConfigStream = new ConfigStream(url.openStream());
        try {
            if (this.xmlConfigRecognizer.isRecognized(xmlConfigStream)) {
                ClientConfig clientConfig = new XmlClientConfigBuilder(url).build();
                return clientConfig;
            }
        }
        finally {
            xmlConfigStream.close();
        }
        ConfigStream yamlConfigStream = new ConfigStream(url.openStream());
        try {
            if (this.yamlConfigRecognizer.isRecognized(yamlConfigStream)) {
                ClientConfig clientConfig = new YamlClientConfigBuilder(url).build();
                return clientConfig;
            }
        }
        finally {
            yamlConfigStream.close();
        }
        throw new InvalidConfigurationException("The provided file is not a valid Hazelcast client configuration: " + url);
    }
}

