/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.session.SessionManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class HazelcastSessionChangeValve
extends ValveBase {
    private final Log log = LogFactory.getLog(HazelcastSessionChangeValve.class);
    private SessionManager sessionManager;
    private Map<String, String> handledSessions = new HashMap<String, String>();

    public HazelcastSessionChangeValve(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.handleTomcatSessionChange(request);
        this.getNext().invoke(request, response);
    }

    private void handleTomcatSessionChange(Request request) throws IOException {
        String currentSessionId = request.getRequestedSessionId();
        if (currentSessionId == null) {
            return;
        }
        String jvmRoute = this.sessionManager.getJvmRoute();
        int index = currentSessionId.indexOf(".");
        String requestedJvmRoute = null;
        if (index > 0) {
            requestedJvmRoute = currentSessionId.substring(index + 1);
        }
        if (requestedJvmRoute == null || requestedJvmRoute.equals(jvmRoute)) {
            return;
        }
        request.changeSessionId(this.getOrCreateHandledSessionId(currentSessionId, jvmRoute));
        request.getSession().invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrCreateHandledSessionId(String currentSessionId, String jvmRoute) throws IOException {
        this.log.debug((Object)String.format("Thread name: %s, Handling session id: %s", Thread.currentThread().getName(), currentSessionId));
        HazelcastSessionChangeValve hazelcastSessionChangeValve = this;
        synchronized (hazelcastSessionChangeValve) {
            if (!this.handledSessions.containsKey(currentSessionId)) {
                this.handledSessions.put(currentSessionId, this.sessionManager.updateJvmRouteForSession(currentSessionId, jvmRoute));
            }
        }
        String handledSessionId = this.handledSessions.get(currentSessionId);
        this.log.info((Object)String.format("Thread name: %s, Handled session id from %s to %s", Thread.currentThread().getName(), currentSessionId, handledSessionId));
        return handledSessionId;
    }
}

