/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.session.SessionManager;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class HazelcastSessionCommitValve
extends ValveBase {
    private final Log log = LogFactory.getLog(HazelcastSessionCommitValve.class);
    private SessionManager sessionManager;

    public HazelcastSessionCommitValve(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            this.getNext().invoke(request, response);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            Session session = request.getSessionInternal(false);
            this.storeOrRemoveSession(session);
        }
    }

    private void storeOrRemoveSession(Session session) {
        if (session != null) {
            if (session.isValid()) {
                this.log.trace((Object)("Request with session completed, saving session " + session.getId()));
                if (session.getSession() != null) {
                    this.log.trace((Object)("HTTP Session present, saving " + session.getId()));
                    this.sessionManager.commit(session);
                } else {
                    this.log.trace((Object)("No HTTP Session present, Not saving " + session.getId()));
                }
            } else {
                this.log.trace((Object)("HTTP Session has been invalidated, removing :" + session.getId()));
                this.sessionManager.remove(session);
            }
        }
    }
}

