/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.session.ClientServerConfigLoader;
import com.hazelcast.session.HazelcastSessionManager;
import com.hazelcast.session.P2PConfigLoader;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnClass(value={HazelcastSessionManager.class})
@ConditionalOnProperty(name={"tsm.autoconfig.enabled"}, havingValue="true", matchIfMissing=true)
public class HazelcastSessionManagerConfiguration {
    private static final String TSM_HAZELCAST_CONFIG_LOCATION = "tsm.config.location";
    private final Log log = LogFactory.getLog(HazelcastSessionManager.class);
    @Value(value="${tsm.config.location:hazelcast-default.xml}")
    private String configLocation;
    @Value(value="${tsm.map.name:default}")
    private String mapName;
    @Value(value="${tsm.sticky:true}")
    private boolean sticky;
    @Value(value="${tsm.process.expires.frequency:6}")
    private int processExpiresFrequency;
    @Value(value="${tsm.deferred.write:true}")
    private boolean deferredWrite;
    @Value(value="${tsm.hazelcast.instance.name:SESSION-REPLICATION-INSTANCE}")
    private String hazelcastInstanceName;
    private boolean clientOnly;

    @Bean
    @ConditionalOnMissingBean(value={Config.class})
    @Conditional(value={HazelcastConfigAvailableCondition.class})
    public Config hazelcastConfigForTomcatSessionManager() throws Exception {
        Config config = new P2PConfigLoader().load(this.configLocation);
        if (config.getInstanceName() == null) {
            config.setInstanceName("SESSION-REPLICATION-INSTANCE");
        }
        return config;
    }

    @Bean
    @ConditionalOnMissingBean(value={ClientConfig.class})
    @Conditional(value={HazelcastClientConfigAvailableCondition.class})
    public ClientConfig hazelcastClientConfigForTomcatSessionManager() throws Exception {
        this.clientOnly = true;
        ClientConfig clientConfig = new ClientServerConfigLoader().load(this.configLocation);
        if (clientConfig.getInstanceName() == null) {
            clientConfig.setInstanceName("SESSION-REPLICATION-INSTANCE");
        }
        return clientConfig;
    }

    @Bean(name={"hazelcastTomcatSessionManagerCustomizer"})
    public WebServerFactoryCustomizer<TomcatServletWebServerFactory> customizeTomcat(HazelcastInstance hazelcastInstance) {
        return new WebServerFactoryCustomizer<TomcatServletWebServerFactory>(){

            public void customize(TomcatServletWebServerFactory factory) {
                factory.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

                    public void customize(Context context) {
                        HazelcastSessionManager manager = new HazelcastSessionManager();
                        manager.setClientOnly(HazelcastSessionManagerConfiguration.this.clientOnly);
                        manager.setMapName(HazelcastSessionManagerConfiguration.this.mapName);
                        manager.setSticky(HazelcastSessionManagerConfiguration.this.sticky);
                        manager.setProcessExpiresFrequency(HazelcastSessionManagerConfiguration.this.processExpiresFrequency);
                        manager.setDeferredWrite(HazelcastSessionManagerConfiguration.this.deferredWrite);
                        manager.setHazelcastInstanceName(HazelcastSessionManagerConfiguration.this.hazelcastInstanceName);
                        context.setManager((Manager)manager);
                        HazelcastSessionManagerConfiguration.this.log.info((Object)String.format("Tomcat context is configured with HazelcastSessionManager => clientOnly: %s, mapName: %s, isSticky: %s, processExpiresFrequency: %d, deferredWrite: %s, hazelcastInstanceName: %s", HazelcastSessionManagerConfiguration.this.clientOnly, HazelcastSessionManagerConfiguration.this.mapName, HazelcastSessionManagerConfiguration.this.sticky, HazelcastSessionManagerConfiguration.this.processExpiresFrequency, HazelcastSessionManagerConfiguration.this.deferredWrite, HazelcastSessionManagerConfiguration.this.hazelcastInstanceName));
                    }
                }});
            }
        };
    }

    private static ConditionOutcome getConditionOutcome(ConditionContext context, boolean forClient) {
        String message = "No explicit config provided using tsm.config.location";
        if (!context.getEnvironment().containsProperty(TSM_HAZELCAST_CONFIG_LOCATION)) {
            if (forClient) {
                return ConditionOutcome.noMatch((String)message);
            }
            return ConditionOutcome.match((String)message);
        }
        String configLocation = context.getEnvironment().getProperty(TSM_HAZELCAST_CONFIG_LOCATION);
        try {
            if (!forClient) {
                new P2PConfigLoader().load(configLocation);
            } else {
                new ClientServerConfigLoader().load(configLocation);
            }
            return ConditionOutcome.match((String)"Found proper config at tsm.config.location");
        }
        catch (Exception e) {
            return ConditionOutcome.noMatch((String)("No proper config at tsm.config.location, Reason: " + e.getMessage()));
        }
    }

    private static class HazelcastClientConfigAvailableCondition
    extends SpringBootCondition {
        private HazelcastClientConfigAvailableCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return HazelcastSessionManagerConfiguration.getConditionOutcome(context, true);
        }
    }

    private static class HazelcastConfigAvailableCondition
    extends SpringBootCondition {
        private HazelcastConfigAvailableCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return HazelcastSessionManagerConfiguration.getConditionOutcome(context, false);
        }
    }
}

