/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigRecognizer;
import com.hazelcast.config.ConfigStream;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.config.UrlYamlConfig;
import com.hazelcast.internal.config.ConfigLoader;
import com.hazelcast.internal.config.MemberXmlConfigRootTagRecognizer;
import com.hazelcast.internal.config.MemberYamlConfigRootTagRecognizer;
import java.net.URL;

class P2PConfigLoader {
    private ConfigRecognizer xmlConfigRecognizer = new MemberXmlConfigRootTagRecognizer();
    private ConfigRecognizer yamlConfigRecognizer = new MemberYamlConfigRootTagRecognizer();

    P2PConfigLoader() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Config load(String path) throws Exception {
        URL url = ConfigLoader.locateConfig((String)path);
        if (url == null) {
            return null;
        }
        ConfigStream xmlConfigStream = new ConfigStream(url.openStream());
        try {
            if (this.xmlConfigRecognizer.isRecognized(xmlConfigStream)) {
                UrlXmlConfig urlXmlConfig = new UrlXmlConfig(url);
                return urlXmlConfig;
            }
        }
        finally {
            xmlConfigStream.close();
        }
        ConfigStream yamlConfigStream = new ConfigStream(url.openStream());
        try {
            if (this.yamlConfigRecognizer.isRecognized(yamlConfigStream)) {
                UrlYamlConfig urlYamlConfig = new UrlYamlConfig(url);
                return urlYamlConfig;
            }
        }
        finally {
            yamlConfigStream.close();
        }
        throw new InvalidConfigurationException("The provided file is not a valid Hazelcast member configuration: " + url);
    }
}

