/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.web.ClusteredSessionService;
import com.hazelcast.web.WebFilterConfig;
import com.hazelcast.web.listener.ClientLifecycleListener;
import com.hazelcast.web.listener.ServerLifecycleListener;
import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;

final class HazelcastInstanceLoader {
    private static final ILogger LOGGER = Logger.getLogger(HazelcastInstanceLoader.class);

    private HazelcastInstanceLoader() {
    }

    static HazelcastInstance loadInstance(ClusteredSessionService sessionService, WebFilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInstanceName() != null) {
            if (filterConfig.isUseClient()) {
                return HazelcastInstanceLoader.loadExistingClient(sessionService, filterConfig.getInstanceName());
            }
            return HazelcastInstanceLoader.loadExistingInstance(sessionService, filterConfig.getInstanceName());
        }
        if (filterConfig.isUseClient()) {
            return HazelcastInstanceLoader.createClient(sessionService, filterConfig);
        }
        return HazelcastInstanceLoader.createInstance(sessionService, filterConfig);
    }

    private static HazelcastInstance createInstance(ClusteredSessionService sessionService, WebFilterConfig filterConfig) throws ServletException {
        Config config;
        LOGGER.info("Creating a new HazelcastInstance for session replication");
        if (filterConfig.getConfigUrl() == null) {
            config = new XmlConfigBuilder().build();
        } else {
            try {
                config = new UrlXmlConfig(filterConfig.getConfigUrl());
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        config.getMapConfig(filterConfig.getMapName()).setMaxIdleSeconds(filterConfig.getSessionTtlSeconds());
        config.addListenerConfig(new ListenerConfig((EventListener)((Object)new ServerLifecycleListener(sessionService))));
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    private static HazelcastInstance createClient(ClusteredSessionService sessionService, WebFilterConfig filterConfig) throws ServletException {
        ClientConfig clientConfig;
        LOGGER.warning("Creating a new HazelcastClient for session replication...");
        LOGGER.warning("make sure this client has access to an already running cluster...");
        if (filterConfig.getConfigUrl() == null) {
            clientConfig = new ClientConfig();
        } else {
            try {
                clientConfig = new XmlClientConfigBuilder(filterConfig.getConfigUrl()).build();
            }
            catch (IOException e) {
                throw new ServletException("Failed to load client config XML file [" + filterConfig.getConfigUrl() + "]:" + e.getMessage(), (Throwable)e);
            }
        }
        if (filterConfig.isStickySession()) {
            int initialBackoffMillis = clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig().getInitialBackoffMillis();
            double multiplier = clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig().getMultiplier();
            clientConfig.getConnectionStrategyConfig().getConnectionRetryConfig().setMaxBackoffMillis(initialBackoffMillis * (int)multiplier);
        }
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)((Object)new ClientLifecycleListener(sessionService))));
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    private static HazelcastInstance loadExistingInstance(ClusteredSessionService sessionService, String instanceName) throws ServletException {
        LOGGER.info("Using existing Hazelcast instance with name [" + instanceName + "] for session replication");
        HazelcastInstance instance = Hazelcast.getHazelcastInstanceByName((String)instanceName);
        if (instance == null) {
            throw new ServletException("Hazelcast instance with name [" + instanceName + "] could not be found.");
        }
        instance.getLifecycleService().addLifecycleListener((LifecycleListener)new ClientLifecycleListener(sessionService));
        return instance;
    }

    private static HazelcastInstance loadExistingClient(ClusteredSessionService sessionService, String instanceName) throws ServletException {
        LOGGER.info("Using existing Hazelcast client instance with name [" + instanceName + "] for session replication");
        HazelcastInstance client = HazelcastClient.getHazelcastClientByName((String)instanceName);
        if (client == null) {
            throw new ServletException("Hazelcast client instance with name [" + instanceName + "] could not be found.");
        }
        client.getLifecycleService().addLifecycleListener((LifecycleListener)new ClientLifecycleListener(sessionService));
        return client;
    }
}

