/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.zookeeper;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.zookeeper.IOUtils;
import com.hazelcast.zookeeper.ZookeeperDiscoveryProperties;
import java.io.Closeable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.UriSpec;

public class ZookeeperDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final String DEFAULT_PATH = "/discovery/hazelcast";
    private static final String DEFAULT_GROUP = "hazelcast";
    private static final int DEFAULT_HZ_PORT = 5701;
    private static final int CURATOR_BASE_SLEEP_TIME_MS = 1000;
    private final DiscoveryNode thisNode;
    private final ILogger logger;
    private String group;
    private CuratorFramework client;
    private ServiceDiscovery<Void> serviceDiscovery;
    private ServiceInstance<Void> serviceInstance;

    public ZookeeperDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.thisNode = discoveryNode;
        this.logger = logger;
    }

    public void start() {
        this.startCuratorClient();
        Address privateAddress = null;
        try {
            privateAddress = new Address("127.0.0.1", 5701);
        }
        catch (UnknownHostException e) {
            this.logger.warning("Cannot bind local host");
        }
        if (this.thisNode != null) {
            privateAddress = this.thisNode.getPrivateAddress();
        }
        this.group = (String)((Object)this.getOrDefault(ZookeeperDiscoveryProperties.GROUP, (Comparable)((Object)DEFAULT_GROUP)));
        try {
            this.serviceInstance = ServiceInstance.builder().uriSpec(new UriSpec("{scheme}://{address}:{port}")).address(privateAddress.getHost()).port(privateAddress.getPort()).name(this.group).build();
            String path = (String)((Object)this.getOrDefault(ZookeeperDiscoveryProperties.ZOOKEEPER_PATH, (Comparable)((Object)DEFAULT_PATH)));
            this.serviceDiscovery = ServiceDiscoveryBuilder.builder(Void.class).basePath(path).client(this.client).thisInstance(this.serviceInstance).build();
            this.serviceDiscovery.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper. ", e);
        }
    }

    private void startCuratorClient() {
        String zookeeperUrl = (String)((Object)this.getOrNull(ZookeeperDiscoveryProperties.ZOOKEEPER_URL));
        if (zookeeperUrl == null) {
            throw new IllegalStateException("Zookeeper URL cannot be null.");
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Using " + zookeeperUrl + " as Zookeeper URL");
        }
        this.client = CuratorFrameworkFactory.newClient((String)zookeeperUrl, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.client.start();
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            Collection members = this.serviceDiscovery.queryForInstances(this.group);
            ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>(members.size());
            for (ServiceInstance serviceInstance : members) {
                String host = serviceInstance.getAddress();
                Integer port = serviceInstance.getPort();
                Address address = new Address(host, port.intValue());
                SimpleDiscoveryNode node = new SimpleDiscoveryNode(address);
                nodes.add((DiscoveryNode)node);
            }
            return nodes;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
    }

    public void destroy() {
        try {
            if (this.serviceDiscovery != null) {
                this.serviceDiscovery.unregisterService(this.serviceInstance);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        finally {
            IOUtils.closeSafely(this.serviceDiscovery);
            IOUtils.closeSafely((Closeable)this.client);
        }
    }
}

