/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.avro.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.file.AvroFileFormat;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.impl.ReadFileFnProvider;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;

public class AvroReadFileFnProvider
implements ReadFileFnProvider {
    @Nonnull
    public <T> FunctionEx<Path, Stream<T>> createReadFileFn(@Nonnull FileFormat<T> format) {
        AvroFileFormat avroFileFormat = (AvroFileFormat)format;
        Class reflectClass = avroFileFormat.reflectClass();
        return (FunctionEx & Serializable)path -> {
            DatumReader datumReader = AvroReadFileFnProvider.datumReader(reflectClass);
            DataFileReader reader = new DataFileReader(path.toFile(), datumReader);
            return (Stream)StreamSupport.stream(reader.spliterator(), false).onClose(() -> Util.uncheckRun(() -> ((DataFileReader)reader).close()));
        };
    }

    private static <T> DatumReader<T> datumReader(Class<T> reflectClass) {
        return reflectClass == null ? new SpecificDatumReader() : new ReflectDatumReader(reflectClass);
    }

    @Nonnull
    public String format() {
        return "avro";
    }
}

