/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.avro.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.internal.util.collection.ReadOptimizedLruCache;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;

public final class AvroSerializerHooks {
    private AvroSerializerHooks() {
    }

    public static <T> byte[] serialize(DatumWriter<T> datumWriter, T data) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
            datumWriter.write(data, (Encoder)encoder);
            encoder.flush();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        out.close();
        return byArray;
    }

    public static <T> T deserialize(DatumReader<T> datumReader, byte[] data) {
        try {
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, null);
            return (T)datumReader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static final class LazyImmutableArray<T>
    extends LazyImmutableContainer<GenericArray<T>>
    implements GenericArray<T> {
        private volatile List<T> immutable;

        private LazyImmutableArray(byte[] serializedArray, Schema schema) {
            super(serializedArray, schema);
        }

        private List<T> immutable() {
            if (this.immutable == null) {
                this.immutable = Collections.unmodifiableList((List)this.deserialized());
            }
            return this.immutable;
        }

        public T peek() {
            return (T)((GenericArray)this.deserialized()).peek();
        }

        public int size() {
            return ((GenericArray)this.deserialized()).size();
        }

        public boolean isEmpty() {
            return ((GenericArray)this.deserialized()).isEmpty();
        }

        public boolean contains(Object o) {
            return ((GenericArray)this.deserialized()).contains(o);
        }

        public boolean containsAll(@Nonnull Collection<?> c) {
            return ((GenericArray)this.deserialized()).containsAll(c);
        }

        public T get(int index) {
            return (T)((GenericArray)this.deserialized()).get(index);
        }

        public int indexOf(Object o) {
            return ((GenericArray)this.deserialized()).indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return ((GenericArray)this.deserialized()).lastIndexOf(o);
        }

        @Nonnull
        public Object[] toArray() {
            return ((GenericArray)this.deserialized()).toArray();
        }

        @Nonnull
        public <T1> T1[] toArray(@Nonnull T1[] a) {
            return ((GenericArray)this.deserialized()).toArray((Object[])a);
        }

        @Nonnull
        public Iterator<T> iterator() {
            return this.immutable().iterator();
        }

        @Nonnull
        public ListIterator<T> listIterator() {
            return this.immutable().listIterator();
        }

        @Nonnull
        public ListIterator<T> listIterator(int index) {
            return this.immutable().listIterator(index);
        }

        @Nonnull
        public List<T> subList(int fromIndex, int toIndex) {
            return this.immutable().subList(fromIndex, toIndex);
        }

        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public void reverse() {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(@Nonnull Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, @Nonnull Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public T set(int index, T element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        public T remove(int index) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LazyImmutableRecord
    extends LazyImmutableContainer<GenericRecord>
    implements GenericRecord {
        private LazyImmutableRecord(byte[] serializedRecord, Schema schema) {
            super(serializedRecord, schema);
        }

        public Object get(int i) {
            return ((GenericRecord)this.deserialized()).get(i);
        }

        public Object get(String key) {
            return ((GenericRecord)this.deserialized()).get(key);
        }

        public void put(String key, Object v) {
            throw new UnsupportedOperationException();
        }

        public void put(int i, Object v) {
            throw new UnsupportedOperationException();
        }
    }

    @ThreadSafe
    private static abstract class LazyImmutableContainer<T extends GenericContainer>
    implements GenericContainer {
        private final byte[] serialized;
        private final Schema schema;
        private volatile T deserialized;

        protected LazyImmutableContainer(byte[] serialized, Schema schema) {
            this.serialized = serialized;
            this.schema = schema;
        }

        protected T deserialized() {
            if (this.deserialized == null) {
                this.deserialized = (GenericContainer)AvroSerializerHooks.deserialize(new GenericDatumReader(this.schema), this.serialized);
            }
            return this.deserialized;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public boolean equals(Object obj) {
            GenericContainer genericContainer;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GenericContainer) || (genericContainer = (GenericContainer)obj).getSchema().getType() != this.schema.getType()) {
                return false;
            }
            return this.deserialized().equals(obj);
        }

        public int hashCode() {
            return this.deserialized().hashCode();
        }

        public String toString() {
            return this.deserialized != null ? this.deserialized.toString() : super.toString();
        }
    }

    public static final class Utf8Hook
    implements SerializerHook<Utf8> {
        public Class<Utf8> getSerializationType() {
            return Utf8.class;
        }

        public Serializer createSerializer() {
            return new ByteArraySerializer<Utf8>(){

                public int getTypeId() {
                    return -329;
                }

                public byte[] write(Utf8 string) {
                    return string.getBytes();
                }

                public Utf8 read(byte[] buffer) {
                    return new Utf8(buffer);
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }

    public static class GenericContainerHook
    implements SerializerHook<GenericContainer> {
        private static final int CACHE_SIZE = 500;
        private static final int CACHE_THRESHOLD = 500 + Math.min(50, 50);

        public Class<GenericContainer> getSerializationType() {
            return GenericContainer.class;
        }

        public Serializer createSerializer(SerializationService serializationService) {
            ((AbstractSerializationService)serializationService).registerFromSuperType(SpecificRecordBase.class, Externalizable.class);
            return new StreamSerializer<GenericContainer>(){
                private final ReadOptimizedLruCache<String, Schema> jsonToSchema = new ReadOptimizedLruCache(500, CACHE_THRESHOLD);
                private final ReadOptimizedLruCache<Schema, String> schemaToJson = new ReadOptimizedLruCache(500, CACHE_THRESHOLD);

                public int getTypeId() {
                    return -330;
                }

                public void write(@Nonnull ObjectDataOutput out, @Nonnull GenericContainer datum) throws IOException {
                    String schemaJson = (String)this.schemaToJson.computeIfAbsent((Object)datum.getSchema(), Schema::toString);
                    out.writeString(schemaJson);
                    out.writeByteArray(datum instanceof LazyImmutableContainer ? ((LazyImmutableContainer)datum).serialized : AvroSerializerHooks.serialize(new GenericDatumWriter(datum.getSchema()), datum));
                }

                @Nonnull
                public GenericContainer read(@Nonnull ObjectDataInput in) throws IOException {
                    String schemaJson = in.readString();
                    byte[] serializedDatum = in.readByteArray();
                    Schema schema = (Schema)this.jsonToSchema.computeIfAbsent((Object)schemaJson, json -> new Schema.Parser().parse(json));
                    switch (schema.getType()) {
                        case RECORD: {
                            return new LazyImmutableRecord(serializedDatum, schema);
                        }
                        case ARRAY: {
                            return new LazyImmutableArray(serializedDatum, schema);
                        }
                        case ENUM: 
                        case FIXED: {
                            return (GenericContainer)AvroSerializerHooks.deserialize(new GenericDatumReader(schema), serializedDatum);
                        }
                    }
                    throw new UnsupportedOperationException("Schema type " + schema.getType() + " is unsupported");
                }
            };
        }

        public boolean isOverwritable() {
            return false;
        }
    }
}

