/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.mysql;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.annotation.EvolvingApi;
import com.hazelcast.jet.cdc.ChangeRecord;
import com.hazelcast.jet.cdc.impl.CdcSourceP;
import com.hazelcast.jet.cdc.impl.ChangeRecordCdcSourceP;
import com.hazelcast.jet.cdc.impl.DebeziumConfig;
import com.hazelcast.jet.cdc.impl.PropertyRules;
import com.hazelcast.jet.cdc.mysql.impl.MySqlSequenceExtractor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.retry.RetryStrategy;
import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

@EvolvingApi
public final class MySqlCdcSources {
    private MySqlCdcSources() {
    }

    @Nonnull
    public static Builder mysql(@Nonnull String name) {
        return new Builder(name);
    }

    public static final class Builder {
        private static final PropertyRules RULES = new PropertyRules().required("database.hostname").required("database.user").required("database.password").required("database.server.name").exclusive("database.whitelist", "database.blacklist").exclusive("table.whitelist", "table.blacklist");
        private final DebeziumConfig config;

        private Builder(@Nonnull String name) {
            Objects.requireNonNull(name, "name");
            this.config = new DebeziumConfig(name, "io.debezium.connector.mysql.MySqlConnector");
            this.config.setProperty("sequence.extractor.class", MySqlSequenceExtractor.class.getName());
            this.config.setProperty("include.schema.changes", "false");
        }

        @Nonnull
        public Builder setDatabaseAddress(@Nonnull String address) {
            this.config.setProperty("database.hostname", address);
            return this;
        }

        @Nonnull
        public Builder setDatabasePort(int port) {
            this.config.setProperty("database.port", Integer.toString(port));
            return this;
        }

        @Nonnull
        public Builder setDatabaseUser(@Nonnull String user) {
            this.config.setProperty("database.user", user);
            return this;
        }

        @Nonnull
        public Builder setDatabasePassword(@Nonnull String password) {
            this.config.setProperty("database.password", password);
            return this;
        }

        @Nonnull
        public Builder setClusterName(@Nonnull String cluster) {
            this.config.setProperty("database.server.name", cluster);
            return this;
        }

        @Nonnull
        public Builder setDatabaseClientId(int clientId) {
            this.config.setProperty("database.server.id", clientId);
            return this;
        }

        @Nonnull
        public Builder setDatabaseWhitelist(String ... dbNameRegExps) {
            this.config.setProperty("database.whitelist", dbNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setDatabaseBlacklist(String ... dbNameRegExps) {
            this.config.setProperty("database.blacklist", dbNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setTableWhitelist(String ... tableNameRegExps) {
            this.config.setProperty("table.whitelist", tableNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setTableBlacklist(String ... tableNameRegExps) {
            this.config.setProperty("table.blacklist", tableNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setColumnBlacklist(String ... columnNameRegExps) {
            this.config.setProperty("column.blacklist", columnNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setSslMode(@Nonnull String mode) {
            this.config.setProperty("database.ssl.mode", mode);
            return this;
        }

        @Nonnull
        public Builder setSslKeystoreFile(@Nonnull String file) {
            this.config.setProperty("database.ssl.keystore", file);
            return this;
        }

        @Nonnull
        public Builder setSslKeystorePassword(@Nonnull String password) {
            this.config.setProperty("database.ssl.keystore.password", password);
            return this;
        }

        @Nonnull
        public Builder setSslTruststoreFile(@Nonnull String file) {
            this.config.setProperty("database.ssl.truststore", file);
            return this;
        }

        @Nonnull
        public Builder setSslTruststorePassword(@Nonnull String password) {
            this.config.setProperty("database.ssl.truststore.password", password);
            return this;
        }

        @Nonnull
        public Builder setReconnectBehavior(@Nonnull RetryStrategy retryStrategy) {
            this.config.setProperty("reconnect.behavior", (Object)retryStrategy);
            return this;
        }

        @Nonnull
        public Builder setShouldStateBeResetOnReconnect(boolean reset) {
            this.config.setProperty("reconnect.reset.state", reset);
            return this;
        }

        @Nonnull
        public Builder setCustomProperty(@Nonnull String key, @Nonnull String value) {
            this.config.setProperty(key, value);
            return this;
        }

        @Nonnull
        public StreamSource<ChangeRecord> build() {
            Properties properties = this.config.toProperties();
            RULES.check(properties);
            properties.setProperty("connect.keep.alive", "true");
            String intervalMs = Builder.getKeepAliveIntervalMs(properties);
            properties.setProperty("connect.keep.alive.interval.ms", intervalMs);
            properties.setProperty("connect.timeout.ms", intervalMs);
            return Sources.streamFromProcessorWithWatermarks((String)properties.getProperty("name"), (boolean)true, (FunctionEx & Serializable)eventTimePolicy -> ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx & Serializable)() -> new ChangeRecordCdcSourceP(properties, eventTimePolicy))));
        }

        private static String getKeepAliveIntervalMs(Properties properties) {
            RetryStrategy reconnectBehavior = (RetryStrategy)properties.get("reconnect.behavior");
            reconnectBehavior = reconnectBehavior == null ? CdcSourceP.DEFAULT_RECONNECT_BEHAVIOR : reconnectBehavior;
            long waitMs = reconnectBehavior.getIntervalFunction().waitAfterAttempt(1);
            return Long.toString(waitMs / 2L);
        }
    }
}

