/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.mysql.impl;

import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.jet.cdc.impl.SequenceExtractor;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class MySqlSequenceExtractor
implements SequenceExtractor {
    private static final String SERVER = "server";
    private static final String BINLOG_FILE = "file";
    private static final String BINLOG_POSITION = "pos";
    private String server;
    private String binlog;
    private long source;

    public long sequence(Map<String, ?> debeziumOffset) {
        return (Long)debeziumOffset.get(BINLOG_POSITION);
    }

    public long source(Map<String, ?> debeziumPartition, Map<String, ?> debeziumOffset) {
        String binlog;
        String server = (String)debeziumPartition.get(SERVER);
        if (this.isSourceNew(server, binlog = (String)debeziumOffset.get(BINLOG_FILE))) {
            long source = MySqlSequenceExtractor.computeSource(server, binlog);
            this.source = this.adjustForCollision(source);
            this.server = server;
            this.binlog = binlog;
        }
        return this.source;
    }

    private boolean isSourceNew(String server, String binlog) {
        return !Objects.equals(this.server, server) || !Objects.equals(this.binlog, binlog);
    }

    private long adjustForCollision(long source) {
        if (this.source == source) {
            if (source == Long.MAX_VALUE) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }
        return source;
    }

    private static long computeSource(String server, String binlog) {
        byte[] bytes = (server + binlog).getBytes(StandardCharsets.UTF_8);
        return HashUtil.MurmurHash3_x64_64((byte[])bytes, (int)0, (int)bytes.length);
    }
}

