/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic;

import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public final class ElasticClients {
    private static final int DEFAULT_PORT = 9200;

    private ElasticClients() {
    }

    @Nonnull
    public static RestClientBuilder client() {
        return ElasticClients.client("localhost", 9200);
    }

    @Nonnull
    public static RestClientBuilder client(@Nonnull String location) {
        return RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)location)});
    }

    @Nonnull
    public static RestClientBuilder client(@Nonnull String hostname, int port) {
        return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(hostname, port)});
    }

    @Nonnull
    public static RestClientBuilder client(@Nonnull String username, @Nonnull String password, @Nonnull String hostname, int port) {
        return ElasticClients.client(username, password, hostname, port, "http");
    }

    @Nonnull
    public static RestClientBuilder client(@Nonnull String username, @Nonnull String password, @Nonnull String hostname, int port, @Nonnull String scheme) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(hostname, port, scheme)}).setHttpClientConfigCallback(arg_0 -> ElasticClients.lambda$client$0((CredentialsProvider)credentialsProvider, arg_0));
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$client$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

