/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;

public class ElasticSourceConfiguration<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SupplierEx<RestHighLevelClient> clientFn;
    private final SupplierEx<SearchRequest> searchRequestFn;
    private final FunctionEx<? super ActionRequest, RequestOptions> optionsFn;
    private final FunctionEx<? super SearchHit, T> mapToItemFn;
    private final boolean slicing;
    private final boolean coLocatedReading;
    private final String scrollKeepAlive;
    private final int retries;

    public ElasticSourceConfiguration(SupplierEx<RestHighLevelClient> clientFn, SupplierEx<SearchRequest> searchRequestFn, FunctionEx<? super ActionRequest, RequestOptions> optionsFn, FunctionEx<? super SearchHit, T> mapToItemFn, boolean slicing, boolean coLocatedReading, String scrollKeepAlive, int retries) {
        this.clientFn = clientFn;
        this.searchRequestFn = searchRequestFn;
        this.optionsFn = optionsFn;
        this.mapToItemFn = mapToItemFn;
        this.slicing = slicing;
        this.coLocatedReading = coLocatedReading;
        this.scrollKeepAlive = scrollKeepAlive;
        this.retries = retries;
    }

    @Nonnull
    public SupplierEx<RestHighLevelClient> clientFn() {
        return this.clientFn;
    }

    @Nonnull
    public SupplierEx<SearchRequest> searchRequestFn() {
        return this.searchRequestFn;
    }

    @Nonnull
    public FunctionEx<? super SearchHit, T> mapToItemFn() {
        return this.mapToItemFn;
    }

    public FunctionEx<? super ActionRequest, RequestOptions> optionsFn() {
        return this.optionsFn;
    }

    public boolean isSlicingEnabled() {
        return this.slicing;
    }

    public boolean isCoLocatedReadingEnabled() {
        return this.coLocatedReading;
    }

    public String scrollKeepAlive() {
        return this.scrollKeepAlive;
    }

    public int retries() {
        return this.retries;
    }
}

