/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.hadoop.impl.ReadHadoopNewApiP;
import com.hazelcast.jet.hadoop.impl.ReadHadoopOldApiP;
import com.hazelcast.jet.hadoop.impl.SerializableConfiguration;
import com.hazelcast.jet.hadoop.impl.WriteHadoopNewApiP;
import com.hazelcast.jet.hadoop.impl.WriteHadoopOldApiP;
import java.security.Permission;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;

public final class HadoopProcessors {
    private HadoopProcessors() {
    }

    @Nonnull
    public static <K, V, R> ProcessorMetaSupplier readHadoopP(@Nonnull Configuration configuration, @Nonnull BiFunctionEx<K, V, R> projectionFn) {
        if ((configuration = SerializableConfiguration.asSerializable(configuration)).get("mapreduce.job.inputformat.class") != null) {
            return new ReadHadoopNewApiP.MetaSupplier<K, V, R>(null, configuration, (ConsumerEx<Configuration>)ConsumerEx.noop(), projectionFn);
        }
        return new ReadHadoopOldApiP.MetaSupplier<K, V, R>((JobConf)configuration, projectionFn);
    }

    @Nonnull
    public static <K, V, R> ProcessorMetaSupplier readHadoopP(@Nullable Permission permission, @Nonnull ConsumerEx<Configuration> configureFn, @Nonnull BiFunctionEx<K, V, R> projectionFn) {
        return new ReadHadoopNewApiP.MetaSupplier<K, V, R>(permission, SerializableConfiguration.asSerializable(new Configuration()), configureFn, projectionFn);
    }

    @Nonnull
    public static <E, K, V> ProcessorMetaSupplier writeHadoopP(@Nonnull Configuration configuration, @Nonnull FunctionEx<? super E, K> extractKeyFn, @Nonnull FunctionEx<? super E, V> extractValueFn) {
        if ((configuration = SerializableConfiguration.asSerializable(configuration)).get("mapreduce.job.outputformat.class") != null) {
            return new WriteHadoopNewApiP.MetaSupplier<E, K, V>(configuration, extractKeyFn, extractValueFn);
        }
        return new WriteHadoopOldApiP.MetaSupplier<E, K, V>((JobConf)configuration, extractKeyFn, extractValueFn);
    }
}

