/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.hadoop.HadoopProcessors;
import com.hazelcast.jet.hadoop.impl.SerializableConfiguration;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Sources;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;

public final class HadoopSources {
    public static final String COPY_ON_READ = "jet.source.copyonread";
    public static final String SHARED_LOCAL_FS = "jet.source.sharedlocalfs";
    public static final String IGNORE_FILE_NOT_FOUND = "jet.source.ignorefilenotfound";

    private HadoopSources() {
    }

    @Nonnull
    public static <K, V, E> BatchSource<E> inputFormat(@Nonnull Configuration configuration, @Nonnull BiFunctionEx<K, V, E> projectionFn) {
        return Sources.batchFromProcessor((String)"hdfsSource", (ProcessorMetaSupplier)HadoopProcessors.readHadoopP(SerializableConfiguration.asSerializable(configuration), projectionFn));
    }

    @Nonnull
    public static <K, V, E> BatchSource<E> inputFormat(@Nonnull ConsumerEx<Configuration> configureFn, @Nonnull BiFunctionEx<K, V, E> projectionFn) {
        return Sources.batchFromProcessor((String)"readHadoop", (ProcessorMetaSupplier)HadoopProcessors.readHadoopP(null, configureFn, projectionFn));
    }

    @Nonnull
    public static <K, V> BatchSource<Map.Entry<K, V>> inputFormat(@Nonnull Configuration jobConf) {
        return HadoopSources.inputFormat(jobConf, Util::entry);
    }
}

