/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

class IndexedInputSplit
implements Comparable<IndexedInputSplit>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int index;
    private org.apache.hadoop.mapred.InputSplit oldSplit;
    private InputSplit newSplit;
    private boolean isOld;

    IndexedInputSplit(int index, org.apache.hadoop.mapred.InputSplit split) {
        this.index = index;
        this.oldSplit = split;
        this.isOld = true;
    }

    IndexedInputSplit(int index, InputSplit split) {
        this.index = index;
        this.newSplit = split;
        this.isOld = false;
    }

    @Nullable
    org.apache.hadoop.mapred.InputSplit getOldSplit() {
        return this.oldSplit;
    }

    @Nullable
    InputSplit getNewSplit() {
        return this.newSplit;
    }

    List<String> getLocations() throws Exception {
        if (this.isOld) {
            return Arrays.asList(this.oldSplit.getLocations());
        }
        return Arrays.asList(this.newSplit.getLocations());
    }

    public String toString() {
        try {
            return "IndexedInputSplit{index " + this.index + ", blocks " + this.blocksOfSplit() + ", locations " + Arrays.toString(this.isOld ? this.oldSplit.getLocations() : this.newSplit.getLocations()) + "}";
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public int compareTo(@Nonnull IndexedInputSplit other) {
        return Integer.compare(this.index, other.index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null) return false;
        if (this.getClass() != o.getClass()) return false;
        IndexedInputSplit that = (IndexedInputSplit)o;
        if (this.index != that.index) return false;
        if (!Objects.equals(this.oldSplit, that.oldSplit)) return false;
        if (!Objects.equals(this.newSplit, that.newSplit)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.index + Objects.hashCode(this.oldSplit) + Objects.hashCode(this.newSplit);
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.writeInt(this.index);
        out.writeBoolean(this.isOld);
        if (this.isOld) {
            out.writeUTF(this.oldSplit.getClass().getName());
            this.oldSplit.write((DataOutput)out);
        } else {
            if (!(this.newSplit instanceof Writable)) {
                throw new IllegalStateException(this.newSplit.getClass().getName() + " does not implement the org.apache.hadoop.io.Writable interface");
            }
            out.writeUTF(this.newSplit.getClass().getName());
            ((Writable)this.newSplit).write((DataOutput)out);
        }
    }

    private void readObject(ObjectInputStream in) throws Exception {
        this.index = in.readInt();
        this.isOld = in.readBoolean();
        Object splitClass = ClassLoaderUtil.newInstance((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)in.readUTF());
        if (this.isOld) {
            this.oldSplit = (org.apache.hadoop.mapred.InputSplit)splitClass;
            this.oldSplit.readFields((DataInput)in);
        } else {
            this.newSplit = (InputSplit)splitClass;
            ((Writable)this.newSplit).readFields((DataInput)in);
        }
    }

    private String blocksOfSplit() {
        String s = this.isOld ? this.oldSplit.toString() : this.newSplit.toString();
        return s.substring(s.lastIndexOf(58) + 1);
    }
}

