/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.json.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class JsonInputFormat
extends FileInputFormat<NullWritable, Object> {
    public static final String JSON_INPUT_FORMAT_BEAN_CLASS = "json.bean.class";
    public static final String JSON_MULTILINE = "json.multiline";

    public RecordReader<NullWritable, Object> createRecordReader(InputSplit split, TaskAttemptContext context) {
        Class clazz;
        Configuration configuration = context.getConfiguration();
        String className = configuration.get(JSON_INPUT_FORMAT_BEAN_CLASS);
        Class clazz2 = clazz = className == null ? null : ReflectionUtils.loadClass((String)className);
        if (this.acceptMultilineJson(context.getConfiguration())) {
            return new MultiLineJsonRecordReader(clazz);
        }
        return new SingleLineJsonRecordReader(clazz);
    }

    protected boolean isSplitable(JobContext context, Path file) {
        boolean multiline = this.acceptMultilineJson(context.getConfiguration());
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        return (null == codec || codec instanceof SplittableCompressionCodec) && !multiline;
    }

    private boolean acceptMultilineJson(Configuration configuration) {
        return configuration.getBoolean(JSON_MULTILINE, true);
    }

    private static class MultiLineJsonRecordReader
    extends RecordReader<NullWritable, Object> {
        private final Class<?> clazz;
        private InputStreamReader reader;
        private Iterator<?> iterator;
        private boolean processed;
        private Object current;

        MultiLineJsonRecordReader(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
            FileSplit fileSplit = (FileSplit)split;
            Path file = fileSplit.getPath();
            FileSystem fs = file.getFileSystem(context.getConfiguration());
            FSDataInputStream in = fs.open(file);
            if (this.hasNoData(in)) {
                in.close();
                this.iterator = Collections.emptyIterator();
                return;
            }
            this.reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
            this.iterator = this.clazz == null ? JsonUtil.mapSequenceFrom((Reader)this.reader) : JsonUtil.beanSequenceFrom((Reader)this.reader, this.clazz);
        }

        private boolean hasNoData(FSDataInputStream in) throws IOException {
            long startPosition = in.getPos();
            boolean hasNoData = in.read() == -1;
            in.seek(startPosition);
            return hasNoData;
        }

        public boolean nextKeyValue() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            this.processed = true;
            return false;
        }

        public NullWritable getCurrentKey() {
            return NullWritable.get();
        }

        public Object getCurrentValue() {
            return this.current;
        }

        public float getProgress() {
            return this.processed ? 1.0f : 0.0f;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private static class SingleLineJsonRecordReader
    extends RecordReader<NullWritable, Object> {
        private final LineRecordReader reader;
        private final Function<? super String, Object> mapper;

        SingleLineJsonRecordReader(Class<?> clazz) {
            this.mapper = SingleLineJsonRecordReader.mapper(clazz);
            this.reader = new LineRecordReader();
        }

        private static FunctionEx<? super String, Object> mapper(Class<?> clazz) {
            return clazz == null ? JsonUtil::mapFrom : (FunctionEx & Serializable)line -> JsonUtil.beanFrom((String)line, (Class)clazz);
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
            this.reader.initialize(split, context);
        }

        public boolean nextKeyValue() throws IOException {
            return this.reader.nextKeyValue();
        }

        public NullWritable getCurrentKey() {
            return NullWritable.get();
        }

        public Object getCurrentValue() {
            return this.mapper.apply(this.reader.getCurrentValue().toString());
        }

        public float getProgress() throws IOException {
            return this.reader.getProgress();
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

