/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.hadoop.impl.IndexedInputSplit;
import com.hazelcast.jet.pipeline.file.impl.FileProcessorMetaSupplier;
import com.hazelcast.logging.ILogger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class ReadHdfsMetaSupplierBase<R>
implements ProcessorMetaSupplier,
FileProcessorMetaSupplier<R> {
    protected transient ILogger logger;

    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        this.logger = context.logger();
    }

    public int preferredLocalParallelism() {
        return 2;
    }

    private static int indexOfMin(int[] ints) {
        return IntStream.range(0, ints.length).boxed().min(Comparator.comparingInt(i -> ints[i])).orElseThrow(() -> new AssertionError((Object)"empty array"));
    }

    private static <T> T getTheOnlyItem(Collection<T> coll) {
        if (coll.size() != 1) {
            throw new AssertionError((Object)("Collection does not have exactly one item: " + coll));
        }
        return coll.iterator().next();
    }

    Map<Address, List<IndexedInputSplit>> assignSplitsToMembers(IndexedInputSplit[] indexedSplits, Address[] memberAddrs) {
        TreeMap splitToCandidates = new TreeMap();
        int[] memberToSplitCount = new int[memberAddrs.length];
        for (IndexedInputSplit is : indexedSplits) {
            splitToCandidates.put(is, IntStream.range(0, memberAddrs.length).filter(i -> {
                try {
                    return this.isSplitLocalForMember(is.getLocations(), memberAddrs[i]);
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow((Throwable)e);
                }
            }).peek(i -> {
                int n = i;
                memberToSplitCount[n] = memberToSplitCount[n] + 1;
            }).boxed().collect(Collectors.toSet()));
        }
        splitToCandidates.entrySet().stream().filter(e -> ((Set)e.getValue()).isEmpty()).peek(e -> this.logger.info("No local member found for " + e.getKey() + ", will be read remotely.")).map(Map.Entry::getValue).forEach(memberIndexes -> {
            int target = ReadHdfsMetaSupplierBase.indexOfMin(memberToSplitCount);
            memberIndexes.add(target);
            int n = target;
            memberToSplitCount[n] = memberToSplitCount[n] + 1;
        });
        this.logger.info("Split counts per member before uniquifying: " + Arrays.toString(memberToSplitCount));
        boolean[] foundNonUnique = new boolean[]{false};
        do {
            splitToCandidates.values().stream().filter(memberIndexes -> memberIndexes.size() > 1).peek(x -> {
                foundNonUnique[0] = true;
            }).forEach(memberIndexes -> {
                int memberWithMostSplits = memberIndexes.stream().max(Comparator.comparingInt(i -> memberToSplitCount[i])).get();
                memberIndexes.remove(memberWithMostSplits);
                int n = memberWithMostSplits;
                memberToSplitCount[n] = memberToSplitCount[n] - 1;
            });
        } while (foundNonUnique[0]);
        this.logger.info("Final split counts per member: " + Arrays.toString(memberToSplitCount));
        return splitToCandidates.entrySet().stream().map(e -> Util.entry((Object)((IndexedInputSplit)e.getKey()), (Object)memberAddrs[(Integer)ReadHdfsMetaSupplierBase.getTheOnlyItem((Collection)e.getValue())])).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
    }

    void printAssignments(Map<Address, List<IndexedInputSplit>> assigned) {
        this.logger.info("Member-to-split assignment: " + assigned.entrySet().stream().flatMap(e -> Stream.concat(Stream.of(e.getKey() + ":"), Optional.of((List)e.getValue()).orElse(Collections.emptyList()).stream().map(Object::toString))).collect(Collectors.joining("\n")));
    }

    private boolean isSplitLocalForMember(List<String> splitLocations, Address memberAddr) {
        try {
            InetAddress inetAddr = memberAddr.getInetAddress();
            return splitLocations.stream().flatMap(loc -> Arrays.stream((InetAddress[])com.hazelcast.jet.impl.util.Util.uncheckCall(() -> InetAddress.getAllByName(loc)))).anyMatch(inetAddr::equals);
        }
        catch (UnknownHostException e) {
            this.logger.warning("Failed to resolve host name for the split, will use host name equality to determine data locality", (Throwable)e);
            return ReadHdfsMetaSupplierBase.isSplitLocalForMember(splitLocations, memberAddr.getScopedHost());
        }
    }

    private static boolean isSplitLocalForMember(List<String> splitLocations, String hostName) {
        if (hostName == null) {
            return false;
        }
        return splitLocations.stream().anyMatch(l -> StringUtil.equalsIgnoreCase((String)l, (String)hostName));
    }
}

