/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

abstract class WholeFileRecordReader<T>
extends RecordReader<NullWritable, T> {
    private final T value;
    private FileSplit fileSplit;
    private Configuration conf;
    private boolean processed;

    WholeFileRecordReader(T value) {
        this.value = value;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
        this.fileSplit = (FileSplit)split;
        this.conf = context.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextKeyValue() throws IOException {
        if (!this.processed) {
            byte[] contents = new byte[(int)this.fileSplit.getLength()];
            Path file = this.fileSplit.getPath();
            FileSystem fs = file.getFileSystem(this.conf);
            FSDataInputStream in = null;
            try {
                in = fs.open(file);
                IOUtils.readFully((InputStream)in, (byte[])contents, (int)0, (int)contents.length);
                this.setValue(contents, 0, contents.length, this.value);
            }
            finally {
                IOUtils.closeStream((Closeable)in);
            }
            this.processed = true;
            return true;
        }
        return false;
    }

    protected abstract void setValue(byte[] var1, int var2, int var3, T var4);

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public T getCurrentValue() {
        return this.value;
    }

    public float getProgress() {
        return this.processed ? 1.0f : 0.0f;
    }

    public void close() {
    }
}

