/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.jet.hadoop.impl.WritableSerializerHook;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

final class WritableSerializerHooks {
    private static final int DEFAULT = -380;
    private static final int INT = -381;
    private static final int LONG = -382;
    private static final int BOOLEAN = -383;
    private static final int FLOAT = -384;
    private static final int DOUBLE = -385;
    private static final int BYTE = -386;
    private static final int TEXT = -387;

    private WritableSerializerHooks() {
    }

    private static class WritableStreamSerializer
    implements StreamSerializer<Writable> {
        private static final ILogger LOGGER = Logger.getLogger(WritableStreamSerializer.class);
        private boolean warnedOnce;

        private WritableStreamSerializer() {
        }

        public int getTypeId() {
            return -380;
        }

        public void write(ObjectDataOutput out, Writable writable) throws IOException {
            if (!this.warnedOnce) {
                LOGGER.warning("Using default Writable serialization without explicit type registration. Consider explicit type registration using WritableSerializerHook.");
                this.warnedOnce = true;
            }
            out.writeString(writable.getClass().getName());
            writable.write((DataOutput)out);
        }

        public Writable read(ObjectDataInput in) throws IOException {
            if (!this.warnedOnce) {
                LOGGER.warning("Using default Writable serialization without explicit type registration. Consider explicit type registration using WritableSerializerHook.");
                this.warnedOnce = true;
            }
            String className = in.readString();
            try {
                Writable instance = (Writable)ClassLoaderUtil.newInstance((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)className);
                instance.readFields((DataInput)in);
                return instance;
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    static final class Default
    implements SerializerHook<Writable> {
        Default() {
        }

        public Class<Writable> getSerializationType() {
            return Writable.class;
        }

        public Serializer createSerializer() {
            return new WritableStreamSerializer();
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    static final class Text
    extends WritableSerializerHook<org.apache.hadoop.io.Text> {
        Text() {
            super(org.apache.hadoop.io.Text.class, org.apache.hadoop.io.Text::new, -387);
        }
    }

    static final class Long
    extends WritableSerializerHook<LongWritable> {
        Long() {
            super(LongWritable.class, LongWritable::new, -382);
        }
    }

    static final class Int
    extends WritableSerializerHook<IntWritable> {
        Int() {
            super(IntWritable.class, IntWritable::new, -381);
        }
    }

    static final class Float
    extends WritableSerializerHook<FloatWritable> {
        Float() {
            super(FloatWritable.class, FloatWritable::new, -384);
        }
    }

    static final class Double
    extends WritableSerializerHook<DoubleWritable> {
        Double() {
            super(DoubleWritable.class, DoubleWritable::new, -385);
        }
    }

    static final class Byte
    extends WritableSerializerHook<ByteWritable> {
        Byte() {
            super(ByteWritable.class, ByteWritable::new, -386);
        }
    }

    static final class Boolean
    extends WritableSerializerHook<BooleanWritable> {
        Boolean() {
            super(BooleanWritable.class, BooleanWritable::new, -383);
        }
    }
}

