/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.ReflectionUtils;

public final class WriteHadoopNewApiP<T, K, V>
extends AbstractProcessor {
    private final RecordWriter<K, V> recordWriter;
    private final TaskAttemptContextImpl taskAttemptContext;
    private final OutputCommitter outputCommitter;
    private final FunctionEx<? super T, K> extractKeyFn;
    private final FunctionEx<? super T, V> extractValueFn;

    private WriteHadoopNewApiP(RecordWriter<K, V> recordWriter, TaskAttemptContextImpl taskAttemptContext, OutputCommitter outputCommitter, FunctionEx<? super T, K> extractKeyFn, FunctionEx<? super T, V> extractValueFn) {
        this.recordWriter = recordWriter;
        this.taskAttemptContext = taskAttemptContext;
        this.outputCommitter = outputCommitter;
        this.extractKeyFn = extractKeyFn;
        this.extractValueFn = extractValueFn;
    }

    public boolean isCooperative() {
        return false;
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        Object t = item;
        this.recordWriter.write(this.extractKeyFn.apply(t), this.extractValueFn.apply(t));
        return true;
    }

    public void close() throws Exception {
        this.recordWriter.close((TaskAttemptContext)this.taskAttemptContext);
        if (this.outputCommitter.needsTaskCommit((TaskAttemptContext)this.taskAttemptContext)) {
            this.outputCommitter.commitTask((TaskAttemptContext)this.taskAttemptContext);
        }
    }

    private static String getUuid(@Nonnull ProcessorMetaSupplier.Context context) {
        return context.hazelcastInstance().getCluster().getLocalMember().getUuid().toString();
    }

    private static OutputFormat getOutputFormat(Configuration config) {
        Class outputFormatClass = config.getClass("mapreduce.job.outputformat.class", TextOutputFormat.class);
        return (OutputFormat)ReflectionUtils.newInstance((Class)outputFormatClass, (Configuration)config);
    }

    private static TaskAttemptContextImpl getTaskAttemptContext(Configuration jobConf, JobContextImpl jobContext, String uuid) {
        return new TaskAttemptContextImpl(jobConf, WriteHadoopNewApiP.getTaskAttemptID(0, jobContext, uuid));
    }

    private static TaskAttemptID getTaskAttemptID(int id, JobContextImpl jobContext, String uuid) {
        return new TaskAttemptID("jet-node-" + uuid, jobContext.getJobID().getId(), TaskType.JOB_SETUP, id, 0);
    }

    private static class Supplier<T, K, V>
    implements ProcessorSupplier {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final Configuration configuration;
        private final FunctionEx<? super T, K> extractKeyFn;
        private final FunctionEx<? super T, V> extractValueFn;
        private transient ProcessorSupplier.Context context;
        private transient OutputCommitter outputCommitter;
        private transient JobContextImpl jobContext;

        Supplier(Configuration configuration, FunctionEx<? super T, K> extractKeyFn, FunctionEx<? super T, V> extractValueFn) {
            this.configuration = configuration;
            this.extractKeyFn = extractKeyFn;
            this.extractValueFn = extractValueFn;
        }

        public void init(@Nonnull ProcessorSupplier.Context context) throws IOException, InterruptedException {
            this.context = context;
            this.jobContext = new JobContextImpl(this.configuration, new JobID());
            OutputFormat outputFormat = WriteHadoopNewApiP.getOutputFormat(this.configuration);
            this.outputCommitter = outputFormat.getOutputCommitter((TaskAttemptContext)WriteHadoopNewApiP.getTaskAttemptContext(this.configuration, this.jobContext, WriteHadoopNewApiP.getUuid((ProcessorMetaSupplier.Context)context)));
        }

        @Nonnull
        public List<Processor> get(int count) {
            return IntStream.range(0, count).mapToObj(localIndex -> {
                try {
                    JobConf copiedConfig = new JobConf(this.configuration);
                    int globalIndex = this.context.memberIndex() * this.context.localParallelism() + localIndex;
                    TaskAttemptID taskAttemptID = WriteHadoopNewApiP.getTaskAttemptID(globalIndex, this.jobContext, WriteHadoopNewApiP.getUuid((ProcessorMetaSupplier.Context)this.context));
                    copiedConfig.set("mapreduce.task.attempt.id", taskAttemptID.toString());
                    copiedConfig.setInt("mapreduce.task.partition", globalIndex);
                    TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl((Configuration)copiedConfig, taskAttemptID);
                    OutputFormat outFormat = WriteHadoopNewApiP.getOutputFormat((Configuration)copiedConfig);
                    RecordWriter recordWriter = outFormat.getRecordWriter((TaskAttemptContext)taskAttemptContext);
                    return new WriteHadoopNewApiP<T, K, V>(recordWriter, taskAttemptContext, this.outputCommitter, this.extractKeyFn, this.extractValueFn);
                }
                catch (Exception e) {
                    throw new JetException((Throwable)e);
                }
            }).collect(Collectors.toList());
        }
    }

    public static class MetaSupplier<T, K, V>
    implements ProcessorMetaSupplier {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final Configuration configuration;
        private final FunctionEx<? super T, K> extractKeyFn;
        private final FunctionEx<? super T, V> extractValueFn;
        private transient OutputCommitter outputCommitter;
        private transient JobContextImpl jobContext;

        public MetaSupplier(Configuration configuration, FunctionEx<? super T, K> extractKeyFn, FunctionEx<? super T, V> extractValueFn) {
            this.configuration = configuration;
            this.extractKeyFn = extractKeyFn;
            this.extractValueFn = extractValueFn;
        }

        public int preferredLocalParallelism() {
            return 2;
        }

        public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
            this.jobContext = new JobContextImpl(this.configuration, new JobID());
            OutputFormat outputFormat = WriteHadoopNewApiP.getOutputFormat(this.configuration);
            this.outputCommitter = outputFormat.getOutputCommitter((TaskAttemptContext)WriteHadoopNewApiP.getTaskAttemptContext(this.configuration, this.jobContext, WriteHadoopNewApiP.getUuid(context)));
            this.outputCommitter.setupJob((JobContext)this.jobContext);
        }

        public void close(Throwable error) throws Exception {
            if (this.outputCommitter != null && this.jobContext != null) {
                this.outputCommitter.commitJob((JobContext)this.jobContext);
            }
        }

        @Nonnull
        public FunctionEx<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return (FunctionEx & Serializable)address -> new Supplier(this.configuration, this.extractKeyFn, this.extractValueFn);
        }
    }
}

