/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.connect.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.jet.kafka.connect.impl.LocalKafkaConnectStats;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalKafkaConnectStatsImpl
implements LocalKafkaConnectStats {
    private static final AtomicLongFieldUpdater<LocalKafkaConnectStatsImpl> sourceRecordPollTotalUpdater = AtomicLongFieldUpdater.newUpdater(LocalKafkaConnectStatsImpl.class, "sourceRecordPollTotal");
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private final long creationTime;
    @Probe(name="sourceRecordPollTotal")
    private volatile long sourceRecordPollTotal;
    @Probe(name="sourceRecordPollTotalAvgTime", unit=ProbeUnit.MS)
    private volatile long sourceRecordPollAvgTime;
    private final AtomicLong sourceRecordPollTimes = new AtomicLong();
    private final AtomicLong sourceRecordPollCount = new AtomicLong();

    public LocalKafkaConnectStatsImpl() {
        this.creationTime = Clock.currentTimeMillis();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void incrementSourceRecordPoll(long amount) {
        sourceRecordPollTotalUpdater.addAndGet(this, amount);
    }

    public void addSourceRecordPollDuration(Duration duration) {
        long times = this.sourceRecordPollTimes.addAndGet(duration.toMillis());
        long count = this.sourceRecordPollCount.incrementAndGet();
        this.sourceRecordPollAvgTime = times / count;
    }

    @Override
    public long getSourceRecordPollTotal() {
        return this.sourceRecordPollTotal;
    }

    public String toString() {
        return "LocalKafkaConnectStatsImpl{sourceRecordPollTotal=" + this.sourceRecordPollTotal + ", sourceRecordPollAvgTime=" + this.sourceRecordPollAvgTime + "}";
    }
}

